// -*- C++ -*-

#ifndef _THRESHOLD_H_
#define _THRESHOLD_H_

#include <new.h>

// DLHeap 2.7.0-like threshold scheme
// for managing a small superheap.

template <int ThresholdBytes, class SuperHeap>
class Threshold : public SuperHeap {
public:

	enum { MIN_LARGE_SIZE = 512 };

  Threshold (void)
    : freed (0),
	freeAllNextMalloc (FALSE)
  {}

  inline void * malloc (size_t sz) {
	  if (sz >= MIN_LARGE_SIZE) {
		  if (freed > 0) {
			freeAllNextMalloc = TRUE;
		  }
	  }
	  if (freeAllNextMalloc) {
		  freed = 0;
		  SuperHeap::freeAll();
		  freeAllNextMalloc = FALSE;
	  }
	  void * ptr = SuperHeap::malloc (sz);
	  if (sz < MIN_LARGE_SIZE) {
		  freed -= getSize(ptr);
		  if (freed < 0) {
			  freed = 0;
		  }
	  }
	  return ptr;
  }


  inline void free (void * ptr) {
    size_t sz = getSize(ptr);
	if (sz < MIN_LARGE_SIZE) {
		freed += sz;
	} else {
		if (sz + freed > ThresholdBytes) {
			freeAllNextMalloc = TRUE;
		}		
	}
    SuperHeap::free (ptr);
  }

private:
  int freed;
  bool freeAllNextMalloc;
};


#endif
