#!/usr/local/bin/perl

use strict;

my $graphtitle = "roboop runtimes";

#my @namelist = ("hoard","ptmalloc","ptmalloc2","mtmalloc");
my %names;

$names{"hoard"} = "Hoard";
$names{"ptmalloc"} = "ptmalloc";
$names{"ptmalloc2"} = "ptmalloc2";
$names{"mtmalloc"} = "mtmalloc";
$names{"Solaris"} = "Solaris";

my @namelist = ("hoard","ptmalloc","ptmalloc2","mtmalloc","Solaris");

my $name;
my %datapoint;

my $item = 0;
my $normalize = 0;

foreach $name (@namelist) {
    open G, "> Results/$name/data";
    open H, "> Results/$name/datal";
    for (my $i = 1; $i <= 1; $i++) {
	open F, "Results/$name/roboop";
	my $total = 0;
	my $count = 0;
	my $min = 1e30;
	my $max = -1e30;
	while (<F>) {
	    chop;
	    if (/([0-9]+\.[0-9]+) seconds/) {
		# print G "$i\t$1\n";
		my $current = $1;
		$total += $1;
		$count++;
		if ($current < $min) {
		    $min = $current;
		}
		if ($current > $max) {
		    $max = $current;
		}
	    }
	}
	my $avg = $total / $count;
	$normalize = $avg if $name eq "hoard";
	my $normalizedAvg = $avg / $normalize;
	my $nfoo = $normalizedAvg * 1.1;
	$item++;
	printf G "$item\t$name\t%.3f\t%.3f\t%.3f\n", $normalizedAvg, $normalizedAvg, $normalizedAvg;
	printf H "$item\t$name\t%.3f\t%.3f\t%.3f\n", $nfoo, $normalizedAvg, $normalizedAvg;
	close F;
    }
    close G;
    close H;
}

open PLOT, "|gnuplot";
print PLOT "set term postscript color\n";
print PLOT "set output \"foo.ps\"\n";
print PLOT "set title \"$graphtitle\"\n";
print PLOT "set ylabel \"Normalized Runtime\"\n";
print PLOT "set xlabel \"Allocator\"\n";
print PLOT "set yrange [0:1.5]\n";
print PLOT "set xrange [0:6]\n";
print PLOT "set style fill solid border 1\n";
# print PLOT "set style fill empty border 1\n";
print PLOT "set boxwidth 0.75\n";

print PLOT "set format y \"%.2f\"\n";
print PLOT "set format x \"%.2f\"\n";

if (1) {
print PLOT "plot ";

foreach $name (@namelist) {
    # next if ($name eq $namelist[-1]);
    print "name = $name\n";
    my $titlename = $names{$name};
    print PLOT "\"Results/$name/data\" using 1:3:xticlabels(2) with boxes fill title \"$titlename\", ";
}
#$name = $namelist[-1];
#my $titlename = $names{$name};
#print PLOT "\"Results/$name/data\" using 1:3:xticlabels(2) with boxes fill title \"$titlename\"\n";
}

# plot .datafile. using 1:(0.5 * $2):4 with labels font "arial,11" tc lt 2

if (1) {
    #print PLOT "plot ";
foreach $name (@namelist) {
    next if ($name eq $namelist[-1]);
    print "name = $name\n";
    my $titlename = $names{$name};
    print PLOT "\"Results/$name/datal\" using 1:3:4 with labels font \"arial,14\" tc lt 0 notitle , ";
}
$name = $namelist[-1];
my $titlename = $names{$name};
print PLOT "\"Results/$name/datal\" using 1:3:4 with labels font \"arial,14\" tc lt 0 notitle\n";

close PLOT;
}


