/* $Log: calloc.h,v $
/* Revision 1.2  2004/10/25 16:36:08  emery
/* Ritual update.
/*
/* Revision 1.1  2003/10/15 15:58:50  emery
/* Initial check-in.
/*
/* Revision 1.2  2003/05/08 21:42:29  emery
/* Ritual check-in.
/*
/* Revision 1.1  2001/08/23 17:19:37  emery
/* The big fig newton.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:16  dgay
/* Initial import of RC tests
/*
 * Revision 1.4  1997/08/04 22:16:46  arda
 * Fix mudlle so that it compiles with g++
 *
 * Revision 1.3  1996/02/09 14:58:11  arda
 * Security holes
 *
 * Revision 1.2  1993/03/29  09:23:39  un_mec
 * Owl: Changed descriptor I/O
 *      New interpreter / compiler structure.
 *
 * Revision 1.3  1993/03/14  16:13:56  dgay
 * Optimised stack & gc ops.
 *
 * Revision 1.1  1992/12/27  21:40:57  un_mec
 * Mudlle source, without any Mume extensions.
 *
 */

/* $Log: calloc.h,v $
/* Revision 1.2  2004/10/25 16:36:08  emery
/* Ritual update.
/*
/* Revision 1.1  2003/10/15 15:58:50  emery
/* Initial check-in.
/*
/* Revision 1.2  2003/05/08 21:42:29  emery
/* Ritual check-in.
/*
/* Revision 1.1  2001/08/23 17:19:37  emery
/* The big fig newton.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:16  dgay
/* Initial import of RC tests
/*
 * Revision 1.4  1997/08/04 22:16:46  arda
 * Fix mudlle so that it compiles with g++
 *
 * Revision 1.3  1996/02/09 14:58:11  arda
 * Security holes
 *
 * Revision 1.2  1993/03/29  09:23:39  un_mec
 * Owl: Changed descriptor I/O
 *      New interpreter / compiler structure.
 *
 * Revision 1.3  1993/03/14  16:13:56  dgay
 * Optimised stack & gc ops.
 *
 * Revision 1.1  1992/12/27  21:40:57  un_mec
 * Mudlle source, without any Mume extensions.
 *
 * Revision 1.1  1992/02/20  17:52:45  gay_d
 * Initial revision
 * */

#ifndef CALLOC_H
#define CALLOC_H

/* Module: calloc
   Date: 14 Feb 92
   Purpose: Fast & easy memory allocator for the mudlle compiler
     Based on the concept of blocks: you allocate memory from a block,
       and can free the whole block at one go.
       Individual deallocations are not possible.
*/

#define USE_CUSTOM_HEAP 0

#if 0 // !(USE_CUSTOM_HEAP)
#define USE_EMERY_HEAP 1
#endif

#if USE_EMERY_HEAP

typedef int * block_t;

#else

typedef struct memblock **block_t;

#endif

block_t new_block(void);
/* Return: A new block from which to allocate some memory.
*/

void free_block(block_t b);
/* Effect: Free all memory allocated in block b.
*/

void *allocate(block_t b, unsigned long size);
/* Effects: Allocates size bytes from block b. This block is aligned
     correctly for all objects.
   Returns: A pointer to the start of the block.
   Note: In this implementation, 12 + average(size)/2 bytes will be wasted
     for every BLOCK_SIZE bytes allocated (see calloc.c).
     Also, size must be smaller than BLOCK_SIZE
*/

#endif
