// This may look like C code, but it is really -*- C++ -*-

#ifndef _schedclass_Processed
#define _schedclass_Processed 1

#include "sched.h"
//#include "node_support.h"

struct event {
	action act;
	MessagePtr pm;
	timetype time;		// at clock== time, call act(arg)
};
#define HEAP_SIZE (4 * MAX_CUBE_SIZE)
struct heap {
	event events[ HEAP_SIZE + 1 ];
	int numevents;			// 1..numevents occupied, 0 ignored
};
struct linkedlist {
#ifdef REFGC
  Ref<linkedlist> next;
#else
  struct linkedlist *next;
#endif
	struct event thisevent;
};

#ifdef REFGC
typedef Ref<linkedlist> LinkedListPtr;
#else
typedef struct linkedlist *LinkedListPtr;
#endif

class schedulerclass {		// Only one instance will exist
	heap eventq;		// events at various future times
	long eventscount;			// # of events performed
	int highwater;				// # in eventq at once
  public:
	timetype clock;				// "now" in hardware ticks
	schedulerclass();				// init
	void post( action, MessagePtr, delta ); // At clock+delta, we will
						// invoke action(int).
						// Goes on event q.
	void run();				// Start up.
	void print( char* );			// Show stats
};

#endif /* _schedclass_Processed */
