#if defined(_WIN32)

#if defined(USE_HOARD)
#pragma comment(lib, "libhoard.lib")
#endif

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <process.h>

#endif


#include <stdio.h>
#include <stdlib.h>


/* Heap Layers stuff. */

#include "fred.h"
#include "cpuinfo.h"
#include "timer.h" 

/* structure transfers variables to the worker threads */
typedef struct tData
{
  int maximumLength;
  int allocCount;
} threadData;

 

void printUsage(char** argv)
{
  fprintf(stderr,"Wrong number of parameters.\nUsage:\n");
  fprintf(stderr,"%s threadCount maxAllocLength allocCount\n\n",
	  argv[0]);
  exit(1);
}

 

extern "C" void * workerThread(void* myThreadData)
{
  int count;
  threadData* myData;
  char* dummy;


  srand(HL::CPUInfo::getThreadId());
  myData=(threadData*)myThreadData;

 

  /* now let us do the real work */
  for(count=0;count<myData->allocCount;count++)
    {
      dummy=(char*)malloc(myData->maximumLength);
      free(dummy);
    }

  return 0;
}

 

int main(int argc,char** argv)
{
  int threadCount;
  int count;
  threadData actData;
  HL::Fred * threadHandles;
 

  /* check parameters */
  if(argc<4 || argc>4)
    printUsage(argv);

 

  /* get parameters for this run */
  threadCount=atoi(argv[1]);
  if(threadCount>64)
    threadCount=64;
  actData.maximumLength=atoi(argv[2])-1;
  actData.allocCount=atoi(argv[3]);

 

  threadHandles = new HL::Fred[threadCount];

 

  printf("Test run with %d simultaneous threads:\n",threadCount);
  HL::Timer t;
  t.start();
  for(count=0;count<threadCount;count++)
    {
      threadHandles[count].create (workerThread, (void*)&actData);
    }

 

  /* wait until all threads are done */
  for(count=0;count<threadCount;count++)
    {
      threadHandles[count].join ();
    }

  t.stop();
  printf("Total time elapsed was: %f seconds",
	 (double) t);
  printf(" for %d alloc operations.\n",
	 actData.allocCount*threadCount);
  /* cleanup */
  delete [] threadHandles;
  return 0;
}
/* End of File */

