// chooseage.c	- as choose.c but uses highest aged (ackcount  - nakcount)
// ------------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Implementation of class: see choose.h for spec.
// Different implementations will try different policies.
// The class is instantiatied ONCE.

#include "node.h"
#include "sched.h"
#include "choose.h"
#include <stream.h>

extern schedulerclass scheduler;
extern node nodes[];
extern int cube_size;
extern int cube_order;
extern const int bitmask[];	// bitmask[i] is 2**i

chooseclass choose;		// ONLY INSTANCE

struct mylink {
	int acknakcount;
};
struct mynode {
	struct mylink mylinks[ MAX_CUBE_ORDER ];
};
struct mynode mynodes[ MAX_CUBE_SIZE ];
static boolean running = true;
int maxcount = -999999999;
int mincount =  999999999;
/*************************************************/
chooseclass::chooseclass()
{
	for( nodenum n = 0; n < MAX_CUBE_SIZE; n++ ) {
		for( linknum l = 0; l < MAX_CUBE_ORDER; l++ ) {
			mynodes[n].mylinks[l].acknakcount = 0;
		}
	}
}
/*******************************************/
#define TICK 100000

void agetick( int dummyarg )
{
	struct mynode *pn = &mynodes[0];
	for( nodenum n = 0; n < cube_size; n++, pn++ ) {
		struct mylink *pl = &pn-> mylinks[0];
		for( linknum l = 0; l < cube_order; l++, pl++ ) {
			if( pl-> acknakcount > 0 ) {
				if( maxcount < pl-> acknakcount )
					maxcount = pl-> acknakcount;
				pl-> acknakcount--;
			}else
			if( pl-> acknakcount < 0 ) {
				if( mincount > pl-> acknakcount )
					mincount = pl-> acknakcount;
				 pl-> acknakcount++;
			}
		}
	}
	if( running == true )scheduler.post( &agetick, 0, TICK );
}


void chooseclass::start()
{
	scheduler.post( &agetick, 0, TICK );
}
/*******************************************/
void chooseclass::sanitycheck()
{
	cout << "Choose algorithm: highest (ack-nak)count, ages every "
		<< TICK << " nanoseconds.\n";
	cout << "Counts reached max of " << maxcount
		<< " and min of " << mincount NL;
	running = false;
}
/*******************************************/
void chooseclass::noteack( nodenum here, linknum lout, struct message *pm )
{
	mynodes[here].mylinks[lout].acknakcount++;
}
/*******************************************/
void chooseclass::notenak( nodenum here, linknum lout, struct message *pm )
{
	mynodes[here].mylinks[lout].acknakcount--;
}
/*****************************************/
//
// rightmost returns the bit position (0..15) of the rightmost set bit.
// Returns -1 if no bit set.

linknum rightmost( int mask )
{
	if( (mask <0) || (mask > cube_size)){
		cout << "ERROR: rightmost invalid argument " << mask NL;
		return 1;
	}
	if( mask == 0 ) return -1;
	int i;
	for( i=0;; i++ ) {
		if( mask & 1 ) break;
		mask >>= 1;
	}
	return i;
}
/*****************************************/
// chooselink returns a link# that is free at that node,
// and that is in both the linkset and the okset.
// Returns -1 if no such.
// The search prefers the highest acknakcount.

linknum chooseclass::outlink( nodenum here, int linkset, int okset )
{
	struct node *phere = &nodes[ here ];
	struct mynode *pmyhere = &mynodes[ here ];
	int bestlack = -999999999;
	int bestl = -1;
	linknum l;
	linkset &= okset;				// bitwise and
	for(;;) {
		l = rightmost( linkset );		// index of bit
		if( l < 0 ) break;
		if( phere->links[l].busy == false ) {
			// found a candidate link
			int lack = pmyhere-> mylinks[l].acknakcount;
			if( bestlack < lack ) {
				// new best
				bestlack = lack;
				bestl = l;
			}
		}
		linkset ^= bitmask[l];			// turn off bit l
	}
	return bestl;
}
/*******************************************/
//	int goodlinkset, badlinkset;
//	linknum lastlink;
//	char bestlink[ MAX_CUBE_SIZE ];
