/*C* $Id: util.h,v 1.5 1997/09/25 19:51:07 james Exp $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef util_h
#define util_h

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

//-----------------------------------------------------------------------------
template <class T> inline void swap(T& a, T& b)
{
 T c = a;
 a = b;
 b = c;
}

//-----------------------------------------------------------------------------
#define rInt(a) (rand() / (RAND_MAX / (a) - 1))

//-----------------------------------------------------------------------------
template <class T> inline T wrap(T& value, T inc, T limit)
{
 while(value < -inc) value += limit;
 value = (value + inc) % limit;
 return value;
}

//-----------------------------------------------------------------------------
inline char* newString(const char* s)
/*
 * Create a new copy of a string
 */
{
 return strcpy(new char[strlen(s)+1], s);
}

extern char* newString(int i);

//-----------------------------------------------------------------------------
inline bool gzFilename(const char* s)
{
 return ((strlen(s) > 3) && !strcmp(s + strlen(s) - 3, ".gz"))? true : false;
}

//--------------------------------------------------------------------------------------------------------------------------------

inline unsigned long long getTicks()
{
 timeval timeVal;
 gettimeofday(&timeVal, NULL);
 return timeVal.tv_sec * 1000000 + timeVal.tv_usec;
}

void waitTicks(long long ticks);

//-----------------------------------------------------------------------------
inline int makeColor(int r, int g, int b) { return (r*6 + g)*6 + b + 1; }

#endif
