/*C* $Id: error.cc,v 1.2 1997/08/11 19:21:31 james Exp $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "debug.h"
#include "error.h"
#include "util.h"
#include <errno.h>
#include <printf.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char* errStr = "UNDEFINED ERROR";

static int printError(FILE* stream, const struct printf_info* info, va_list* app)
{
 (void)info; (void)app;
 if(!errStr)
  {
   fprintf(stream, "(no error)");
   return 10;
  }
 fprintf(stream, "%s", errStr);
 return strlen(errStr);
}

static int printErrorArginfo(const struct printf_info* info, size_t n, int* argtypes)
{
 (void)info; (void)n; (void)argtypes;
 return 0;
}

static int printErrnoString(FILE* stream, const struct printf_info* info, va_list* app)
{
 (void)info; (void)app;
 int i = errno;
 fprintf(stream, "%s", strerror(i));
 return(strlen(strerror(i)));
}

static int printErrnoStringArginfo(const struct printf_info* info, size_t n, int* argtypes)
{
 (void)info; (void)n; (void)argtypes;
 return 0;
}

void setError(const char* format, ...)
{
 if(!format) { errStr = newString("no error"); return; }
 va_list ap;
 va_start(ap, format);
 char* s;
 vasprintf(&s, format, ap);
 va_end(ap);
 if(errStr) delete errStr;
 errStr = s; // yes, this is really necessary
 VPRINTF("<error> set to \"%s\"\n", errStr);
}

void initError()
{
 VPRINTF("<error> initialising\n");
#if !defined __GLIBC__ || __GLIBC__ < 2
 register_printf_function('z', (printf_function)printError, printErrorArginfo);
 register_printf_function('y', (printf_function)printErrnoString, printErrnoStringArginfo);
#else
 register_printf_function('z', printError, printErrorArginfo);
 register_printf_function('y', printErrnoString, printErrnoStringArginfo);
#endif
}

const char* errnoStr()
{
 return strerror(errno);
}
