/*C* $Id: file.h,v 1.3 1997/08/19 08:33:06 james Exp $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef file_h
#define file_h

#include "error.h"
#include "Object.h"
#include <stdio.h>
#include <sys/types.h>

class File : public Object
{
public:
 File();
 File(const char* filename, const char* mode);
 File(FILE* _fp);
#ifndef NDEBUG
 File(File& object); // This fatal(...)s, 'cos it's silly
#endif
 virtual ~File();

 operator FILE* () { return fp; }
 operator bool () { return fp? true : false; }
 bool ok() { return fp ? true : false; }
 File& operator = (FILE* _fp) { close(); fp = _fp; return *this; }

 virtual int close();
 virtual FILE* open(const char* filename, const char* mode);

 bool read(void *data, size_t size);
 bool write(const void *data, size_t size);

 size_t read(void* data, size_t size, size_t count) { return fread(data, size, count, fp); }
 size_t write(const void* data, size_t size, size_t count) { return fwrite(data, size, count, fp); }

 bool read(int& i) { return read(&i, sizeof(i)); }
 bool write(const int& i) { return write(&i, sizeof(i)); }

 int getChar() { return getc(fp); }
 int unGetChar(int c) { return ungetc(c, fp); }

 int scanf(const char* format, ...);

 int seek(long int offset, int whence) { return fseek(fp, offset, whence); }

 bool eof() { return feof(fp)? true : false; }
 bool error() { return ferror(fp)? true : false; }
 bool ready() { return (fp && !ferror(fp) && !feof(fp))? true : false; }

protected:
 FILE* fp;
 bool fpWantsClosing;
};

extern File fStdOut, fStdIn, fStdErr;

class Pipe : public File
{
public:
 Pipe();
 Pipe(const char* filename, const char* mode);
 virtual int close();
 virtual FILE* open(const char* filename, const char* mode);
};

class GzipPipe : public Pipe
{
public:
 GzipPipe() : Pipe() {}
 GzipPipe(const char* filename, const char* mode);
 virtual FILE* open(const char* filename, const char* mode);
};

typedef bool (Object::*objectWriteFunc)(File& f);
typedef Object* (*objectCreateFunc)(File& f);

extern bool save(const char* filename, Object* object, objectWriteFunc write);
extern Object* load(const char* filename, objectCreateFunc create);

#endif
