/*C* $Id: level.h,v 1.5 1997/09/10 06:48:47 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Ghost.h"
#include "globals.h"
#include "Pos.h"
#include "../util/Collection.h"
#include <stdio.h>

class Level
{
private:
 char data[lvlW][lvlH];
 
public:
 int dots;

 Level();
 ~Level() {}
 
 Level& operator=(const Level& level);
 
 bool load(class File* f);
 bool load(const char *filename);

 void getGhosts(Collection<class Ghost>* Ghosts);

 bool save(FILE *fp);
 
 void draw(Pos p);
 void drawKBo(Pos p);
 void drawK(Pos p);
 void drawKU(Pos p);
 void draw();

 void setSquare(Pos p, int type);
 void setSquareAndDrawK(Pos p, int type);
 void setSquareAndDrawKU(Pos p, int type);
 int getSquare(Pos p) { return data[p.x][p.y]; }
 
 void clear(Pos p);
 void clearAndDrawKBo(Pos p);
 void clear();

 bool checkLevel();

 Pos find(int block);
};
