/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Actor.h"
#include "../util/util.h"

Actor::Actor()
{
 p = Pos(0, 0);
 q = 0;
 dir = None;
 moving = false;
}

Actor::~Actor()
{
}

bool Actor::move()
{
 if(!moving) return true;
 q++;
 if((q >= sprW && (dir == Left || dir == Right)) || (q >= sprH && (dir == Up || dir == Down)))
  {
   q = 0;
   wrap(p.x, xInc[dir], worldSize.x);
   wrap(p.y, yInc[dir], worldSize.y);
   return true;
  }
 return false;
}

void Actor::setPos(Pos _p)
{
 p = _p;
 q = 0;
 dir = None;
 moving = false;
}

void Actor::setDir(Dir _dir)
{
 dir = _dir;
 moving = true;
}

void Actor::turnBack()
{
 if(q != 0)
  {
   wrap(p.x, xInc[dir], lvlW + 1);
   wrap(p.y, yInc[dir], lvlH + 1);
   q = sprW-q;
  }
 dir = behindOf[dir];
 moving = true;
}

