/*C* $Id$
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef vgaxx_Rect_h
#define vgaxx_Rect_h

#include "Point.h"
#include "../util/Object.h"

class Rect : public Object
{
public:
 Rect() { }
 Rect(Point p, Point z) { x = p.x; y = p.y; w = z.x; h = z.y; }
 Rect(int _x, int _y, int _w, int _h) { x = _x, y = _y; w = _w; h = _h; }
 bool onScreen() const;
 bool inside(Rect r) const;
 bool contains(Point p) const { return (p.x >= left() && p.x <= right() && p.y >= top() && p.y <= bottom()); }
 bool contains(Rect r) const { return r.inside(*this); }
 bool meets(Rect r) const { return r.left() <= right() && left() <= r.right() && r.top() <= bottom() && top() <= r.bottom(); }

 // these return the rect position in various forms

 inline int left() const { return x; }
 inline int right() const { return x + w - 1; }
 inline int top() const { return y; }
 inline int bottom() const { return y + h - 1; }

 inline int xMiddle() const { return x + w/2; }
 inline int yMiddle() const { return y + h/2; }

 inline Point topLeft() const { return Point(left(), top()); }
 inline Point topRight() const { return Point(right(), top()); }
 inline Point bottomLeft() const { return Point(left(), bottom()); }
 inline Point bottomRight() const { return Point(right(), bottom()); }

 inline Point middle() const { return topLeft() + z() / 2; }
 inline Point topMiddle() const { return Point(xMiddle(), top()); }
 inline Point bottomMiddle() const { return Point(xMiddle(), bottom()); }
 inline Point leftMiddle() const { return Point(left(), yMiddle()); }
 inline Point rightMiddle() const { return Point(right(), yMiddle()); }

 inline int width() const { return w; }
 inline int height() const { return h; }

 Point p() const { return Point(x, y); }
 Point z() const { return Point(w, h); }

 // set the rect to a new position

 inline int left(int i) { w = right() - i + 1; return x = i; }
 inline int right(int i) { w = i - x + 1; return i; }
 inline int top(int i) { h = bottom() - i + 1; return y = i; }
 inline int bottom(int i) { h = i - y + 1; return i; }

 // other stuff

 Rect& clipTo(Rect r);
 Rect& operator += (Point p) { x += p.x; y += p.y; return *this; }
 Rect operator + (Point p) { return Rect(x + p.x, y + p.y, w, h); }
 Rect operator - (Point p) { return Rect(x - p.x, y - p.y, w, h); }
 int x, y, w, h;
};

extern Rect emptyRect;

#endif
