/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "mode.h"
#include "Rect.h"
#include "../util/Collection.h"
#include "../util/util.h"

template class Collection<Rect>;
template void swap(Collection<Rect>*&, Collection<Rect>*&);

bool Rect::inside(Rect r) const
{
 return (left() >= r.left() && right() <= r.right() && top() >= r.top() && bottom() <= r.bottom())? true : false;
}

bool Rect::onScreen() const
{
 return inside(screenRect);
}


Rect& Rect::clipTo(Rect r)
{
 if(left() < r.left()) left(r.left());
 if(right() > r.right()) right(r.right());
 if(top() < r.top()) top(r.top());
 if(bottom() > r.bottom()) bottom(r.bottom());
 return *this;
}

Rect emptyRect;
