/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "CtrlEvent.h"
#include "Events.h"
#include "../gl/Console.h"
#include "../gl/Keyboard.h"
#include "../gl/Mouse.h"
#include "../gl/Sprite.h"
#include "../gl/VgaBlur.h"

//--------------------------------------------------------------------------------------------------------------------------------

Events::Events(Collection<Control>* _controls)
 : Collection<CtrlEvent>()
{
 controls = _controls;
}

//--------------------------------------------------------------------------------------------------------------------------------

int Events::operator () ()
{
 assert(mouse->sprite);

 // set up a few things (well, one)

 screen->clipping = true;

 // before we start, draw all controls

 foreach(*controls, i)
  {
   Control* control = controls->at(i);
   screen->clippingRect = control->rect();
   control->draw(control->rect());
  }
 screen->keepAndUpdate();

 Control* mouseOwner = NULL; // set when you press the left mouse button
 quitFlag = false;
 while(1)
  {
   
   // grab mouse events

   MouseEvent* me;
   while((me = mouse->getEvent()))
    {
     // cast the event
     MouseLBUpEvent* mlue = dynamic_cast<MouseLBUpEvent*>(me);
     MouseMoveEvent* mme = dynamic_cast<MouseMoveEvent*>(me);

     // proccess each control, from last (highest) to first
     for(int i = controls->length()-1; i >= 0; i--)
      {
       Control* control = controls->at(i);
       if(mouseOwner? mouseOwner != control : !control->rect().contains(me->p)) continue;

       if(MouseLBDownEvent* mlbde = dynamic_cast<MouseLBDownEvent*>(me))
	{
	 add(new LBDownCtrlEvent(control, mlbde->p));
	 mouseOwner = control; // this will finally be set to the highest control
	}

       if(mlue) // left button released
	{
	 add(new LBUpCtrlEvent(control, mlue->p));
	 mouseOwner = NULL;
	}

       if(MouseRBDownEvent* mrbde = dynamic_cast<MouseRBDownEvent*>(me))
	add(new RBDownCtrlEvent(control, mrbde->p));

       if(mme) // mouse moved
	add(new PtrMoveCtrlEvent(control, mme->p));

       MouseDbClickEvent* mdce = dynamic_cast<MouseDbClickEvent*>(me);
       if(mdce) control->evDbClick(mdce->p);

       break;
      }

     delete me;
     if(quitFlag) goto quit;
    }
   
   // grab keyboard events

   KeyboardEvent* ke;
   while((ke = keyboard->getEvent()))
    {
     KeyDownEvent* kde = dynamic_cast<KeyDownEvent*>(ke);
     if(kde) foreach(*controls, i) controls->at(i)->evKeyDown(kde->key);

     KeyUpEvent* kue = dynamic_cast<KeyUpEvent*>(ke);
     if(kue) foreach(*controls, i) controls->at(i)->evKeyUp(kue->key);

     KeyRepEvent* kre = dynamic_cast<KeyRepEvent*>(ke);
     if(kre) foreach(*controls, i) controls->at(i)->evKeyRep(kre->key);
    }

   // process events till none are left
   
   int loops = 0;
   while(length())
    {
     foreach(*this, i)
      {
       (*at(i))();
       del(i);
       if(quitFlag) goto quit;
      }
     pack();
     if(++loops == 100) fatal("events looped 100 times, now that can't be good\n");
    }
   
   screen->clippingRect = screenRect;
   screen->blur2(mouse->sprite->draw(screen, mouse->position()));
   screen->copyBlurs();
  }

quit:
 VPRINTF("<control> events finished ret=%d\n", ret);
 return ret;
}

//--------------------------------------------------------------------------------------------------------------------------------

void Events::quit(int _ret)
{
 VPRINTF("<control> quit requested ret=%d\n", _ret);
 quitFlag = true;
 ret = _ret;
}

//--------------------------------------------------------------------------------------------------------------------------------

void Events::redraw(Rect r)
{
 foreach(*controls, i)
  {
   Control* control = controls->at(i);
   if(control->rect().meets(r))
    {
     screen->clippingRect = control->rect();
     screen->clippingRect.clipTo(r);
     control->draw(screen->clippingRect);
    }
  }
 screen->keepAndBlur1(r);
}

//--------------------------------------------------------------------------------------------------------------------------------
