/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef control_CtrlEvent_h
#define control_CtrlEvent_h

#include "Control.h"
#include "../util/Object.h"

//--------------------------------------------------------------------------------------------------------------------------------

class CtrlEvent : public Object
{
public:
 virtual void operator () () = 0;
};

//--------------------------------------------------------------------------------------------------------------------------------

class MouseCtrlEvent : public CtrlEvent
{
protected:
 Control* destination;
 Point p;

public:
 MouseCtrlEvent(Control* _destination, Point _p)
  {
   destination = _destination;
   p = _p;
  }
};

//--------------------------------------------------------------------------------------------------------------------------------

class LBDownCtrlEvent : public MouseCtrlEvent
{
public:
 LBDownCtrlEvent(Control* _dest, Point _p) : MouseCtrlEvent(_dest, _p) { };
 virtual void operator () () { destination->evLBDown(p); }
};

//--------------------------------------------------------------------------------------------------------------------------------

class LBUpCtrlEvent : public MouseCtrlEvent
{
public:
 LBUpCtrlEvent(Control* _dest, Point _p) : MouseCtrlEvent(_dest, _p) { };
 virtual void operator () () { destination->evLBUp(p); }
};

//--------------------------------------------------------------------------------------------------------------------------------

class RBDownCtrlEvent : public MouseCtrlEvent
{
public:
 RBDownCtrlEvent(Control* _dest, Point _p) : MouseCtrlEvent(_dest, _p) { };
 virtual void operator () () { destination->evRBDown(p); }
};

//--------------------------------------------------------------------------------------------------------------------------------

class PtrMoveCtrlEvent : public MouseCtrlEvent
{
public:
 PtrMoveCtrlEvent(Control* _dest, Point _p) : MouseCtrlEvent(_dest, _p) { };
 virtual void operator () () { destination->evPtrMove(p); }
};

//--------------------------------------------------------------------------------------------------------------------------------

class ContextEvent : public CtrlEvent
{
private:
 Control* dest;
 int id;

public:
 ContextEvent(Control* _dest, int _id)
  {
   dest = _dest;
   id = _id;
  }

 virtual void operator () ()
  { dest->evContext(id); }
};

//--------------------------------------------------------------------------------------------------------------------------------

class CommandEvent : public CtrlEvent
{
private:
 Control* dest;
 int id;

public:
 CommandEvent(Control* _dest, int _id)
  {
   dest = _dest;
   id = _id;
  }

 virtual void operator () ()
  {
   VPRINTF("<control> command id=%d dest=%p\n", id, dest);
   dest->evCommand(id);
  }
};

//--------------------------------------------------------------------------------------------------------------------------------

#endif
