module Hat.Foreign.Ptr
  (Ptr(),gnullPtr,gcastPtr,acastPtr,hcastPtr,gplusPtr,aplusPtr,hplusPtr
    ,galignPtr,aalignPtr,halignPtr,gminusPtr,aminusPtr,hminusPtr,FunPtr()
    ,gnullFunPtr,gcastFunPtr,acastFunPtr,hcastFunPtr,gcastFunPtrToPtr
    ,acastFunPtrToPtr,hcastFunPtrToPtr,gcastPtrToFunPtr,acastPtrToFunPtr
    ,hcastPtrToFunPtr,gfreeHaskellFunPtr,afreeHaskellFunPtr
    ,hfreeHaskellFunPtr) where

import qualified Hat.PreludeBasic 
import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.Prelude 
import Hat.Foreign.BuiltinTypes 
import Hat.PreludeBuiltinTypes 
import qualified Foreign.Ptr 

gnullPtr :: T.RefSrcPos -> T.RefExp -> T.R (Ptr a)

gnullPtr pnullPtr p = T.uconstUse pnullPtr p snullPtr

snullPtr =
  T.uconstDef T.mkRoot anullPtr
    (\ p -> (fromPtr T.fromId) p Foreign.Ptr.nullPtr)

gcastPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (Ptr b))

gcastPtr pcastPtr p = T.ufun1 acastPtr pcastPtr p hcastPtr

hcastPtr z1castPtr kcastPtr =
  (fromPtr T.fromId) kcastPtr
    (Foreign.Ptr.castPtr ((toPtr T.toId) kcastPtr z1castPtr))

gplusPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (T.Fun Int (Ptr b)))

gplusPtr pplusPtr p = T.ufun2 aplusPtr pplusPtr p hplusPtr

hplusPtr z1plusPtr z2plusPtr kplusPtr =
  (fromPtr T.fromId) kplusPtr
    (Foreign.Ptr.plusPtr ((toPtr T.toId) kplusPtr z1plusPtr)
      (T.toInt kplusPtr z2plusPtr))

galignPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (T.Fun Int (Ptr a)))

galignPtr palignPtr p = T.ufun2 aalignPtr palignPtr p halignPtr

halignPtr z1alignPtr z2alignPtr kalignPtr =
  (fromPtr T.fromId) kalignPtr
    (Foreign.Ptr.alignPtr ((toPtr T.toId) kalignPtr z1alignPtr)
      (T.toInt kalignPtr z2alignPtr))

gminusPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (T.Fun (Ptr b) Int))

gminusPtr pminusPtr p = T.ufun2 aminusPtr pminusPtr p hminusPtr

hminusPtr z1minusPtr z2minusPtr kminusPtr =
  T.fromInt kminusPtr
    (Foreign.Ptr.minusPtr ((toPtr T.toId) kminusPtr z1minusPtr)
      ((toPtr T.toId) kminusPtr z2minusPtr))

gnullFunPtr :: T.RefSrcPos -> T.RefExp -> T.R (FunPtr a)

gnullFunPtr pnullFunPtr p = T.uconstUse pnullFunPtr p snullFunPtr

snullFunPtr =
  T.uconstDef T.mkRoot anullFunPtr
    (\ p -> (fromFunPtr T.fromId) p Foreign.Ptr.nullFunPtr)

gcastFunPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FunPtr a) (FunPtr b))

gcastFunPtr pcastFunPtr p = T.ufun1 acastFunPtr pcastFunPtr p hcastFunPtr

hcastFunPtr z1castFunPtr kcastFunPtr =
  (fromFunPtr T.fromId) kcastFunPtr
    (Foreign.Ptr.castFunPtr ((toFunPtr T.toId) kcastFunPtr z1castFunPtr))

gcastFunPtrToPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FunPtr a) (Ptr b))

gcastFunPtrToPtr pcastFunPtrToPtr p =
  T.ufun1 acastFunPtrToPtr pcastFunPtrToPtr p hcastFunPtrToPtr

hcastFunPtrToPtr z1castFunPtrToPtr kcastFunPtrToPtr =
  (fromPtr T.fromId) kcastFunPtrToPtr
    (Foreign.Ptr.castFunPtrToPtr
      ((toFunPtr T.toId) kcastFunPtrToPtr z1castFunPtrToPtr))

gcastPtrToFunPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (FunPtr b))

gcastPtrToFunPtr pcastPtrToFunPtr p =
  T.ufun1 acastPtrToFunPtr pcastPtrToFunPtr p hcastPtrToFunPtr

hcastPtrToFunPtr z1castPtrToFunPtr kcastPtrToFunPtr =
  (fromFunPtr T.fromId) kcastPtrToFunPtr
    (Foreign.Ptr.castPtrToFunPtr
      ((toPtr T.toId) kcastPtrToFunPtr z1castPtrToFunPtr))

gfreeHaskellFunPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FunPtr a) (IO T.Tuple0))

gfreeHaskellFunPtr pfreeHaskellFunPtr p =
  T.ufun1 afreeHaskellFunPtr pfreeHaskellFunPtr p hfreeHaskellFunPtr

hfreeHaskellFunPtr z1freeHaskellFunPtr kfreeHaskellFunPtr =
  (T.fromIO T.fromTuple0) kfreeHaskellFunPtr
    (Foreign.Ptr.freeHaskellFunPtr
      ((toFunPtr T.toId) kfreeHaskellFunPtr z1freeHaskellFunPtr))

geqPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (T.Fun (Ptr a) Bool))

geqPtr peqPtr p = T.ufun2 aeqPtr peqPtr p heqPtr

heqPtr z1eqPtr z2eqPtr keqPtr =
  fromBool keqPtr
    (((toPtr T.toId) keqPtr z1eqPtr) Prelude.== ((toPtr T.toId) keqPtr z2eqPtr))

gleqPtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr a) (T.Fun (Ptr a) Bool))

gleqPtr pleqPtr p = T.ufun2 aleqPtr pleqPtr p hleqPtr

hleqPtr z1leqPtr z2leqPtr kleqPtr =
  fromBool kleqPtr
    (((toPtr T.toId) kleqPtr z1leqPtr)
      Prelude.<=
      ((toPtr T.toId) kleqPtr z2leqPtr))

gshowsPrecPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun (Ptr a) (T.Fun String String)))

gshowsPrecPtr pshowsPrecPtr p =
  T.ufun3 ashowsPrecPtr pshowsPrecPtr p hshowsPrecPtr

hshowsPrecPtr z1showsPrecPtr z2showsPrecPtr z3showsPrecPtr kshowsPrecPtr =
  fromString kshowsPrecPtr
    (Prelude.showsPrec (T.toInt kshowsPrecPtr z1showsPrecPtr)
      ((toPtr T.toId) kshowsPrecPtr z2showsPrecPtr)
      (toString kshowsPrecPtr z3showsPrecPtr))

instance Eq ((Ptr a))
  where
  
  (!==) (%==) p = T.uconstUse (%==) p (|==)
  
  (|==) = T.uconstDef T.mkRoot (+*!=&=*!=#&==) (\ p -> geqPtr T.mkNoSrcPos p)
  

instance Ord ((Ptr a))
  where
  
  (!<=) (%<=) p = T.uconstUse (%<=) p (|<=)
  
  (|<=) = T.uconstDef T.mkRoot (+*$=&=*$=#*<=) (\ p -> gleqPtr T.mkNoSrcPos p)
  

instance Show ((Ptr a))
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a54v3v54v26showsPrec
      (\ p -> gshowsPrecPtr T.mkNoSrcPos p)
  

geqFunPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FunPtr a) (T.Fun (FunPtr a) Bool))

geqFunPtr peqFunPtr p = T.ufun2 aeqFunPtr peqFunPtr p heqFunPtr

heqFunPtr z1eqFunPtr z2eqFunPtr keqFunPtr =
  fromBool keqFunPtr
    (((toFunPtr T.toId) keqFunPtr z1eqFunPtr)
      Prelude.==
      ((toFunPtr T.toId) keqFunPtr z2eqFunPtr))

gleqFunPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (FunPtr a) (T.Fun (FunPtr a) Bool))

gleqFunPtr pleqFunPtr p = T.ufun2 aleqFunPtr pleqFunPtr p hleqFunPtr

hleqFunPtr z1leqFunPtr z2leqFunPtr kleqFunPtr =
  fromBool kleqFunPtr
    (((toFunPtr T.toId) kleqFunPtr z1leqFunPtr)
      Prelude.<=
      ((toFunPtr T.toId) kleqFunPtr z2leqFunPtr))

gshowsPrecFunPtr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun (FunPtr a) (T.Fun String String)))

gshowsPrecFunPtr pshowsPrecFunPtr p =
  T.ufun3 ashowsPrecFunPtr pshowsPrecFunPtr p hshowsPrecFunPtr

hshowsPrecFunPtr z1showsPrecFunPtr z2showsPrecFunPtr z3showsPrecFunPtr
  kshowsPrecFunPtr =
  fromString kshowsPrecFunPtr
    (Prelude.showsPrec (T.toInt kshowsPrecFunPtr z1showsPrecFunPtr)
      ((toFunPtr T.toId) kshowsPrecFunPtr z2showsPrecFunPtr)
      (toString kshowsPrecFunPtr z3showsPrecFunPtr))

instance Eq ((FunPtr a))
  where
  
  (!==) (%==) p = T.uconstUse (%==) p (|==)
  
  (|==) = T.uconstDef T.mkRoot (++*=&=+*=#^==) (\ p -> geqFunPtr T.mkNoSrcPos p)
  

instance Ord ((FunPtr a))
  where
  
  (!<=) (%<=) p = T.uconstUse (%<=) p (|<=)
  
  (|<=) =
    T.uconstDef T.mkRoot (++^=&=+^=#@<=) (\ p -> gleqFunPtr T.mkNoSrcPos p)
  

instance Show ((FunPtr a))
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a69v3v69v29showsPrec
      (\ p -> gshowsPrecFunPtr T.mkNoSrcPos p)
  

tForeign_Ptr = T.mkModule "Foreign.Ptr" "Foreign/Ptr.hs" Prelude.False

anullPtr = T.mkVariable tForeign_Ptr 230001 230061 3 0 "nullPtr" Prelude.False

acastPtr = T.mkVariable tForeign_Ptr 240001 240070 3 1 "castPtr" Prelude.False

aplusPtr = T.mkVariable tForeign_Ptr 250001 250077 3 2 "plusPtr" Prelude.False

aalignPtr = T.mkVariable tForeign_Ptr 260001 260077 3 2 "alignPtr" Prelude.False

aminusPtr = T.mkVariable tForeign_Ptr 270001 270079 3 2 "minusPtr" Prelude.False

anullFunPtr =
  T.mkVariable tForeign_Ptr 290001 300022 3 0 "nullFunPtr" Prelude.False

acastFunPtr =
  T.mkVariable tForeign_Ptr 310001 320034 3 1 "castFunPtr" Prelude.False

acastFunPtrToPtr =
  T.mkVariable tForeign_Ptr 330001 340036 3 1 "castFunPtrToPtr" Prelude.False

acastPtrToFunPtr =
  T.mkVariable tForeign_Ptr 350001 360036 3 1 "castPtrToFunPtr" Prelude.False

afreeHaskellFunPtr =
  T.mkVariable tForeign_Ptr 380001 390039 3 1 "freeHaskellFunPtr" Prelude.False

aeqPtr = T.mkVariable tForeign_Ptr 420001 430033 3 2 "eqPtr" Prelude.False

aleqPtr = T.mkVariable tForeign_Ptr 440001 450034 3 2 "leqPtr" Prelude.False

ashowsPrecPtr =
  T.mkVariable tForeign_Ptr 460001 470050 3 3 "showsPrecPtr" Prelude.False

aeqFunPtr = T.mkVariable tForeign_Ptr 570001 580042 3 2 "eqFunPtr" Prelude.False

aleqFunPtr =
  T.mkVariable tForeign_Ptr 590001 600043 3 2 "leqFunPtr" Prelude.False

ashowsPrecFunPtr =
  T.mkVariable tForeign_Ptr 610001 620056 3 3 "showsPrecFunPtr" Prelude.False

(+*!=&=*!=#&==) =
  T.mkVariable tForeign_Ptr 500004 500014 16 0 "==" Prelude.False

(+*$=&=*$=#*<=) =
  T.mkVariable tForeign_Ptr 520004 520015 16 0 "<=" Prelude.False

a54v3v54v26showsPrec =
  T.mkVariable tForeign_Ptr 540003 540026 3 0 "showsPrec" Prelude.False

(++*=&=+*=#^==) =
  T.mkVariable tForeign_Ptr 650004 650017 16 0 "==" Prelude.False

(++^=&=+^=#@<=) =
  T.mkVariable tForeign_Ptr 670004 670018 16 0 "<=" Prelude.False

a69v3v69v29showsPrec =
  T.mkVariable tForeign_Ptr 690003 690029 3 0 "showsPrec" Prelude.False
