module System.Locale
  ( TimeLocale(..)
  , defaultTimeLocale
  , iso8601DateFormat
  , rfc822DateFormat
  ) where

import Locale

iso8601DateFormat :: Maybe String -> String
iso8601DateFormat timeFmt =
    "%Y-%m-%d" ++ case timeFmt of
             Nothing  -> "" 
             Just fmt -> ' ' : fmt

rfc822DateFormat :: String
rfc822DateFormat = "%a, %_d %b %Y %H:%M:%S %Z"
