/*
  gyrus-dialog-mailbox-new.c

  GYRUS -- GNOME Cyrus Administrator. Dialog New Mailbox.

  Copyright (C) 2004 Claudio Saavedra Valds <csaavedra@alumnos.utalca.cl>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
*/

#include <config.h>

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <glib-object.h>

#include "glib/gi18n.h"
#include "gyrus-common.h"
#include "gyrus-dialog-mailbox-new.h"
#include "gyrus-main-app.h"
#include "gyrus-admin.h"
#include "gyrus-admin-mailbox.h"

static GtkDialogClass *parent_class = NULL;

static void gyrus_dialog_mailbox_new_class_init (GyrusDialogMailboxNewClass *class);
static void gyrus_dialog_mailbox_new_init (GyrusDialogMailboxNew *dialog);
static void gyrus_dialog_mailbox_new_finalize (GObject *object);
static void gyrus_dialog_mailbox_new_destroy (GtkObject *object);

/* Callbacks */

void
gyrus_dialog_mailbox_new_on_button_ok_clicked (GtkButton *button,
					       gpointer user_data)
{
	GyrusDialogMailboxNew *dialog;
	GyrusMainApp *app;
	gchar *current_path;
	const gchar *mailbox;
	gint quota;
	gchar *error;
	gchar *quota_invalid;
	
	dialog = GYRUS_DIALOG_MAILBOX_NEW (user_data);
	app = GYRUS_MAIN_APP (gtk_window_get_transient_for (GTK_WINDOW (dialog)));
	
	GyrusAdmin *admin = gyrus_main_app_get_current_admin (app);
	
	current_path = gyrus_admin_get_selected_mailbox (admin);

	if (!current_path)
		current_path = g_strdup ("user");

	mailbox = gtk_entry_get_text (GTK_ENTRY (dialog->priv->entry_mailbox));

	if (gtk_toggle_button_get_active
	    (GTK_TOGGLE_BUTTON (dialog->priv->checkbutton_quota))) {
		quota = 1024 * g_strtod (gtk_entry_get_text
				  (GTK_ENTRY (dialog->priv->entry_quota)),
				  &quota_invalid);
	} else
		quota = -1;

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
					  (dialog->priv->checkbutton_quota)) &&
	    *quota_invalid) {
		gyrus_common_show_message (NULL, GTK_MESSAGE_ERROR,
					   _("Quota not valid"));
		
		gtk_editable_select_region (GTK_EDITABLE
					    (dialog->priv->entry_quota),
					    0, -1);
	}
	else if (gyrus_admin_mailbox_new (admin, mailbox,
					  current_path, quota, &error)) {
		gyrus_admin_refresh_users_list (admin);
		gyrus_admin_select_mailbox (admin, current_path);

		gtk_widget_destroy (GTK_WIDGET (dialog));
		
	}
	else {
		gyrus_common_show_message (GTK_WINDOW (dialog),
					   GTK_MESSAGE_ERROR, error);
		gtk_editable_select_region (GTK_EDITABLE (dialog->priv->entry_mailbox),
					    0, -1);
		g_free (error);
	}
	
	g_free (current_path);
}

void
gyrus_dialog_mailbox_new_on_checkbutton_toggled (GtkToggleButton *toggle,
						 gpointer user_data)
{
	GyrusDialogMailboxNew *dialog = GYRUS_DIALOG_MAILBOX_NEW (user_data);
	
	gboolean sensitive = gtk_toggle_button_get_active (toggle);
	
	gtk_widget_set_sensitive (dialog->priv->label_quota, sensitive);
	gtk_widget_set_sensitive (dialog->priv->entry_quota, sensitive);

	sensitive =
		gtk_entry_has_text (GTK_ENTRY (dialog->priv->entry_mailbox)) &&
		(!gtk_toggle_button_get_active
		 (GTK_TOGGLE_BUTTON (dialog->priv->checkbutton_quota)) ||
		 gtk_entry_has_text (GTK_ENTRY (dialog->priv->entry_quota)));

	gtk_widget_set_sensitive (dialog->priv->button_ok, sensitive);
}

void
gyrus_dialog_mailbox_new_on_entry_changed (GtkEditable *editable,
					   gpointer user_data)
{
	GyrusDialogMailboxNew *dialog = GYRUS_DIALOG_MAILBOX_NEW (user_data);

	gboolean sensitive = gtk_entry_has_text (GTK_ENTRY (dialog->priv->entry_mailbox)) &&
		(!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (dialog->priv->checkbutton_quota)) ||
		 gtk_entry_has_text (GTK_ENTRY (dialog->priv->entry_quota)));
	
	gtk_widget_set_sensitive (dialog->priv->button_ok, sensitive);
}


GType
gyrus_dialog_mailbox_new_get_type (void)
{
	static GType type = 0;
  
	if (!type) {
		static const GTypeInfo info = {
				sizeof (GyrusDialogMailboxNewClass),
				NULL,           /* base_init */
				NULL,           /* base_finalize */
				(GClassInitFunc) gyrus_dialog_mailbox_new_class_init,
				NULL,           /* class_finalize */
				NULL,           /* class_data */
				sizeof (GyrusDialogMailboxNew),
				0,              /* n_preallocs */
				(GInstanceInitFunc) gyrus_dialog_mailbox_new_init,
				0
		};
		
		type = g_type_register_static (GTK_TYPE_DIALOG,
					       "GyrusDialogMailboxNew",
					       &info, 0);
	}
	
	return type;
}

static void
gyrus_dialog_mailbox_new_class_init (GyrusDialogMailboxNewClass *class)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (class);
	GtkObjectClass *object_class = GTK_OBJECT_CLASS (class);

	parent_class = g_type_class_peek_parent (class);

	gobject_class->finalize = gyrus_dialog_mailbox_new_finalize;
	object_class->destroy = gyrus_dialog_mailbox_new_destroy;
}

void
gyrus_dialog_mailbox_new_init_get_widgets (GyrusDialogMailboxNew *dialog)
{
	GladeXML *xml_dialog;
	gchar *file_glade;
	GtkWidget *table;

	file_glade = g_strdup_printf ("%s%c%s", GYRUS_GLADE_DIR,
				      G_DIR_SEPARATOR, "create_mailbox.glade");
	xml_dialog = glade_xml_new (file_glade, "table_dialog", "gyrus");
	g_free (file_glade);

	table = glade_xml_get_widget (xml_dialog, "table_dialog");
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), table);
	
	dialog->priv->button_ok     = gtk_button_new_from_stock (GTK_STOCK_OK);
	dialog->priv->button_cancel = gtk_button_new_from_stock (GTK_STOCK_CANCEL);

	gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (dialog)->action_area),
				     dialog->priv->button_cancel);
	gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (dialog)->action_area),
				     dialog->priv->button_ok);

	dialog->priv->checkbutton_quota = glade_xml_get_widget (xml_dialog, "checkbutton_quota");
	dialog->priv->entry_mailbox     = glade_xml_get_widget (xml_dialog, "entry_mailbox");
	dialog->priv->entry_quota       = glade_xml_get_widget (xml_dialog, "entry_quota");
	dialog->priv->label_mailbox     = glade_xml_get_widget (xml_dialog, "label_mailbox");
	dialog->priv->label_quota       = glade_xml_get_widget (xml_dialog, "label_quota");
}

void
gyrus_dialog_mailbox_new_init_connect_signals (GyrusDialogMailboxNew *dialog)
{
	g_signal_connect (G_OBJECT (dialog->priv->button_ok), "clicked",
			  G_CALLBACK (gyrus_dialog_mailbox_new_on_button_ok_clicked),
			  dialog);

	g_signal_connect (G_OBJECT (dialog->priv->checkbutton_quota), "toggled",
			  G_CALLBACK (gyrus_dialog_mailbox_new_on_checkbutton_toggled),
			  dialog);

	g_signal_connect_swapped (G_OBJECT (dialog->priv->button_cancel), "clicked",
				  G_CALLBACK (gtk_widget_destroy), dialog);

	g_signal_connect (G_OBJECT (dialog->priv->entry_mailbox), "changed",
			  G_CALLBACK (gyrus_dialog_mailbox_new_on_entry_changed),
			  dialog);
	
	g_signal_connect (G_OBJECT (dialog->priv->entry_quota), "changed",
			  G_CALLBACK (gyrus_dialog_mailbox_new_on_entry_changed),
			  dialog);
}

static void
gyrus_dialog_mailbox_new_init (GyrusDialogMailboxNew *dialog)
{
	dialog->priv = g_new0 (GyrusDialogMailboxNewPrivate, 1);

	gtk_window_set_title (GTK_WINDOW (dialog), _("New mailbox"));
	gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
	
	gyrus_dialog_mailbox_new_init_get_widgets (dialog);
	gyrus_dialog_mailbox_new_init_connect_signals (dialog);
	gtk_widget_set_sensitive (dialog->priv->button_ok, FALSE);
	gtk_widget_show_all (GTK_WIDGET (dialog));
}

static void
gyrus_dialog_mailbox_new_finalize (GObject *object)
{
	GyrusDialogMailboxNew *dialog_mailbox_new;
	g_return_if_fail (GYRUS_IS_DIALOG_MAILBOX_NEW(object));
	dialog_mailbox_new = GYRUS_DIALOG_MAILBOX_NEW (object);

	g_free (dialog_mailbox_new->priv);
	G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
gyrus_dialog_mailbox_new_destroy (GtkObject *object)
{
	GyrusDialogMailboxNew *dialog_mailbox_new;
	g_return_if_fail (GYRUS_IS_DIALOG_MAILBOX_NEW (object));
	dialog_mailbox_new = GYRUS_DIALOG_MAILBOX_NEW (object);

	GTK_OBJECT_CLASS (parent_class)->destroy (object);
}

GtkWidget *
gyrus_dialog_mailbox_new_new (void)
{
	GyrusDialogMailboxNew *dialog;
	dialog = g_object_new (GYRUS_TYPE_DIALOG_MAILBOX_NEW, NULL);
	return GTK_WIDGET (dialog);
}
