 /*
 *  ViewersWindow.h: Interface and declarations for the ViewersWindow Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef VIEWERSWIN_H
#define VIEWERSWIN_H

#import <AppKit/NSWindow.h>

@class NSString;
@class NSArray;
@class NSDictionary;
@class NSFileManager;
@class NSWorkspace;
@class NSNotification;
@class Shelf;
@class History;
@class GWorkspace;

@interface ViewersWindow : NSWindow 
{
  NSString *myPath;
	NSArray *selectedPaths;
  BOOL viewsapps;
  int resizeIncrement;
	NSMutableArray *viewers;
	NSArray *viewersPaths;
  NSString *viewType;
  
  id mainview;
	BOOL usingSplit;
  Shelf *shelf;
	id viewer;

	History *historyWin;
	NSMutableArray *ViewerHistory;
	int currHistoryPos;
  	
  GWorkspace *gw;
  NSFileManager *fm;  
}

- (id)initForPath:(NSString *)path 
 withViewersPaths:(NSArray *)vpaths 
			canViewApps:(BOOL)canview;

- (void)makeViewersWithBundlesPaths:(NSArray *)bpaths type:(NSString *)vtype;

- (void)changeViewer:(NSString *)newViewType;

- (id)viewer;

- (void)adjustSubviews;

- (void)viewFrameDidChange:(NSNotification *)notification;

- (void)setSelectedPaths:(NSArray *)paths;

- (NSString *)myPath;

- (NSPoint)locationOfIconForPath:(NSString *)apath;

- (void)activate;

- (void)setViewerSelection:(NSArray *)selPaths;

- (void)viewersListDidChange:(NSNotification *)notification;

- (void)columnsWidthChanged:(NSNotification *)notification;

- (void)updateDefaults;

- (void)updateInfoString;

- (NSString *)viewType;

- (BOOL)viewsApps;

- (void)selectAll;

//
// Menu operations
//
- (void)openSelection:(id)sender;

- (void)openSelectionAsFolder:(id)sender;

- (void)editFile:(id)sender;

- (void)newFolder:(id)sender;

- (void)newFile:(id)sender;

- (void)duplicateFiles:(id)sender;

- (void)deleteFiles:(id)sender;

- (void)setViewerType:(id)sender;

- (void)selectAllInViewer:(id)sender;

- (void)print:(id)sender;

@end

//
// history methods
//
@interface ViewersWindow (historyMethods)

- (void)addToHistory:(NSString *)path;

- (void)tuneHistory;

- (void)setCurrentHistoryPosition:(int)newPosition;

- (void)goToHistoryPosition:(int)position;

- (void)goBackwardInHistory:(id)sender;

- (void)goForwardInHistory:(id)sender;

@end

//
// shelf delegate methods
//

@interface ViewersWindow (shelfDelegateMethods)

- (NSArray *)getSelectedPaths;

- (void)shelf:(Shelf *)sender setCurrentSelection:(NSArray *)paths;

- (void)shelf:(Shelf *)sender openCurrentSelection:(NSArray *)paths 
																				 newViewer:(BOOL)newv;
@end

//
// Viewers Delegate Methods
//

@interface ViewersWindow (ViewerDelegateMethods)

- (void)setTheSelectedPaths:(id)paths;

- (void)setTitleAndPath:(id)apath selectedPaths:(id)paths;

- (void)addWatcherForPath:(id)path;

- (void)removeWatcherForPath:(id)path;

- (void)addPathToHistory:(NSArray *)paths;

- (int)sortTypeForDirectoryAtPath:(id)path;

- (void)openTheSelectedPaths:(id)paths newViewer:(BOOL)newv;

- (void)newViewerAtPath:(id)path canViewApps:(BOOL)viewapps;

- (BOOL)openFile:(id)fullPath;

- (void)performFileOperationWithDictionary:(id)opdict;

- (NSImage *)smallIconForFile:(NSString*)aPath;

- (NSImage *)smallIconForFiles:(NSArray*)pathArray;

- (NSString *)getTrashPath;

- (void)updateTheInfoString;

- (int)getBrowserColumnsWidth;

- (int)getIconViewCellsWidth;

- (int)getWindowFrameWidth;

- (int)getWindowFrameHeight;

@end

#endif // VIEWERSWIN_H
