/*
 * Copyright (C) 2002-2005 
 * Emmanuel Saracco <esaracco@users.labs.libre-entreprise.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef ENABLE_CLAMAV
#include "ucclam.h"
#include "utils.h"

UCClam *
uc_ucclam_new (void)
{
  UCClam *clam = NULL;

  clam = g_new0 (UCClam, 1);
  clam->virname = NULL;
  clam->size = 0;
  memset (&clam->limits, 0, sizeof (struct cl_limits));
  clam->limits.maxfiles = 1;
  clam->limits.maxfilesize = 10 * 1048576;
  clam->limits.maxreclevel = 1;
  clam->limits.maxratio = 200;
  clam->limits.archivememlim = 0;
  if (cl_loaddbdir (cl_retdbdir (), &clam->root, &clam->no) ||
      cl_build (clam->root))
    {
      uc_ucclam_free (clam);
      return NULL;
    }

  return clam;
}

gboolean
uc_ucclam_scan (UCClam * clam, const gchar * path)
{
  gint fd = 0;
  gboolean ret = FALSE;

  if ((fd = open (path, O_RDONLY)) == -1)
    {
      g_warning ("Can't open file \"%s\" to scan it for virii!", path);
      return FALSE;
    }

  uc_utils_debug ("[SECURITY] Scanning %s for virii...\n", path);
  ret = (cl_scandesc (fd, &clam->virname, &clam->size, clam->root,
		      &clam->limits, CL_SCAN_STDOPT) == CL_VIRUS);
  if (ret)
    uc_utils_debug ("[SECURITY]\tVirus found here!\n");

  close (fd);

  return ret;
}

void
uc_ucclam_free (UCClam * clam)
{
  if (!clam)
    return;

  if (clam->root)
    cl_free (clam->root), clam->root = NULL;

  g_free (clam), clam = NULL;
}
#endif
