//$Id: resource-manager.h,v 1.12 2001/11/09 23:55:42 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_RESOURCE_MANAGER_H
#define GUIKACHU_RESOURCE_MANAGER_H

namespace Guikachu
{
    class ResourceManager;
}


#include "resource.h"
#include "app-res.h"
#include "storage-node.h"
#include <map>
#include <set>
#include <sigc++/signal_system.h>

namespace Guikachu
{
    class NoCase
    {
    public:
	bool operator () (const std::string& x, const std::string& y) const;
    };
    
    class ResourceManager: public SigC::Object
    {
	typedef std::map<std::string, Resources::Resource*, NoCase> resource_map_t;
	typedef std::set<std::string, NoCase> id_set_t;
	
	static resource_map_t          resource_map;
	static id_set_t                id_set;
	static bool                    dirty;
	static Resources::Application *app;

    public:
	static Resources::Resource* create_resource (Resources::Type type,
						     std::string     id = "");
	static void remove_resource (Resources::Resource *resource);
	static bool rename_resource (const std::string &old_id,
				     const std::string &new_id);

	static bool register_id   (const std::string &id);
	static void unregister_id (const std::string &id);

	static std::string create_id   (const std::string &prefix);
	static std::string validate_id (std::string id);

	static std::set<Resources::Resource*> get_resources   ();
	static Resources::Resource*           get_resource    (const std::string &id);
	static Resources::Application*        get_application () { return app; };
	
	// Signals
	static SigC::Signal1<void, Resources::Resource*> resource_created;
	static SigC::Signal1<void, Resources::Resource*> resource_removed;
	
	// Persistance
	enum IOResult
	{
	    IO_OK,
	    IO_NOTFOUND,
	    IO_INVALID
	};
	
	static void     reset      ();
	static bool     is_dirty   ();
	static IOResult load       (const std::string &filename);
	static IOResult save       (const std::string &filename);
	static void     export_rcp (const std::string &filename); 

    private:
	static void resource_changed_cb ();
	static Resources::Resource* load_resource (StorageNode &node);
    };
}

#endif /* !GUIKACHU_RESOURCE_MANAGER_H */
