//$Id: resizeable-prop.cc,v 1.3 2001/08/31 16:11:38 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "resizeable-prop.h"

#include "config.h"
#include <libgnome/libgnome.h>

#include "widgets/size-entry.h"
#include "widgets/auto-toggle.h"

using namespace Guikachu::GUI::FormEditor;

void ResizeableProperties::add_controls (Widgets::Resizeable *res,
					 GUI::PropertyTable  &proptable)
{
    Gtk::Widget *control;
    
    /* Width */
    control = new GUI::SizeEntry (res->width);
    control = new GUI::AutoToggle (*manage (control), res->manual_width);
    proptable.add (_("_Width:"), *manage (control),
		   _("Horizontal size of the widget "
		     "(check to set manually)"));

    /* Height */
    control = new GUI::SizeEntry (res->height);
    control = new GUI::AutoToggle (*manage (control), res->manual_height);
    proptable.add (_("_Height:"), *manage (control),
		   _("Vertical size of the widget "
		     "(check to set manually)"));
}
