//$Id: dialog-win.cc,v 1.20 2001/11/06 17:04:30 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "dialog-win.h"

#include "config.h"
#include <libgnome/libgnome.h>

#ifdef GUIKACHU_USE_WM_ICONS
#include <libgnomeui/gnome-window-icon.h>
#endif

#include <gtk--/menu.h>
#include <gtk--/notebook.h>
#include <gnome--/dialog.h>
#include <sigc++/retbind.h>
#include "argumentsink.h"

#include "widgets/propertytable.h"
#include "widgets/resource-combo.h"
#include "widgets/entry.h"
#include "widgets/text.h"
#include "widgets/string-list.h"

namespace Guikachu
{
    namespace GUI
    {
	namespace DialogWindow_Helpers
	{
	    class ButtonList: public StringList
	    {
		Resources::Dialog *res;
	    public:
		ButtonList (Resources::Dialog *res);
	    protected:
		virtual void update ();
	    private:
		void add_cb    (unsigned int new_index);
		void remove_cb (unsigned int old_index);
		void up_cb     (unsigned int old_index);
		void down_cb   (unsigned int old_index);

		void button_default_cb ();
	    };
	}
    }
}

using namespace Guikachu;
using GUI::DialogWindow_Helpers::ButtonList;

ButtonList::ButtonList (Resources::Dialog *res_):
    StringList (res_->buttons),
    res (res_)
{
    Gtk::Button *button_default = new Gtk::Button (_("Default"));
    button_default->clicked.connect (SigC::slot (this, &ButtonList::button_default_cb));
    button_default->set_sensitive (false);
    add_button (*manage (button_default));

    item_added.connect (SigC::slot (this, &ButtonList::add_cb));
    item_removed.connect (SigC::slot (this, &ButtonList::remove_cb));
    up.connect   (SigC::slot (this, &ButtonList::up_cb));
    down.connect (SigC::slot (this, &ButtonList::down_cb));

    update ();

    list_widget.unselect_item (0);
    list_widget.select_item (0);
}

void ButtonList::button_default_cb ()
{
    unsigned int index = get_selected_row ();
    res->default_button = index;

    list_widget.unselect_item (index);
    list_widget.select_item (index);
}

void ButtonList::add_cb (unsigned int new_index)
{
    unsigned int default_button = res->default_button;

    if (default_button >= new_index)
	res->default_button += 1;    
}

void ButtonList::remove_cb (unsigned int index)
{
    unsigned int default_button = res->default_button;

    if (default_button == 0)
	return;
    
    if (default_button >= index)
	res->default_button -= 1;
}

void ButtonList::up_cb (unsigned int old_index)
{
    unsigned int old_default = res->default_button;
    
    if (old_index == old_default)
	res->default_button -= 1;
    if (old_index - 1 == old_default)
	res->default_button = old_index;
}

void ButtonList::down_cb (unsigned int old_index)
{
    unsigned int old_default = res->default_button;
    
    if (old_index == old_default)
	res->default_button += 1;
    if (old_index + 1 == old_default)
	res->default_button = old_index;
}

void ButtonList::update ()
{
    update_block = true;
    
    clear_list ();
    
    const value_t &curr_val = property;
    unsigned int index = 0;
    unsigned int default_button = res->default_button;
    for (value_t::const_iterator i = curr_val.begin ();
	 i != curr_val.end (); i++, index++)
    {
	if (index == default_button)
	    add_to_list (index, "*" + *i + "*");
	else
	    add_to_list (index, *i);
    }
    
    update_block = false;
}

GUI::DialogWindow::DialogWindow (Resources::Dialog *res_):
    res (res_),
    window (GTK_WINDOW_DIALOG),
    update_block (true)
{
    using namespace SigC;
    
    window.delete_event.connect (slot (this, &DialogWindow::delete_event_impl));
    window.set_policy (false, true, false);
    
#ifdef GUIKACHU_USE_WM_ICONS
    gnome_window_icon_set_from_file (window.gtkobj (), GNOME_ICONDIR "/guikachu.png");
#endif

    Gtk::Notebook *notebook = new Gtk::Notebook;
    
    GUI::PropertyTable *proptable = new GUI::PropertyTable;
    Gtk::Widget *control;

    /* Resource ID */
    control = new GUI::Entry (false, res->id);
    proptable->add (_("Resource _ID:"), *manage (control));

    /* Title */
    control = new GUI::Entry (true, res->title);
    proptable->add (_("_Title:"), *manage (control));
    
    /* Type */
    Gtk::Menu *type_menu = new Gtk::Menu;

#define DIALOG_TYPE(s,t)						\
	    type_menu->items ().push_back (				\
		Gtk::Menu_Helpers::MenuElem (				\
		    s,							\
		    bind (slot (this, &DialogWindow::type_menu_cb),	\
			  Resources::t)));

    DIALOG_TYPE (_("Information"),  DIALOG_INFORMATION);
    DIALOG_TYPE (_("Confirmation"), DIALOG_CONFIRMATION);
    DIALOG_TYPE (_("Warning"),      DIALOG_WARNING);
    DIALOG_TYPE (_("Error"),        DIALOG_ERROR);

#undef DIALOG_TYPE
    
    type_menu->show_all ();
    type_combo.set_menu (*manage (type_menu));
    proptable->add (_("T_ype:"), type_combo);
    
    /* Help ID */
    control = new GUI::ResourceCombo (Resources::RESOURCE_STRING, res->help_id);
    proptable->add (_("_Help ID:"), *manage (control));

    /* Text */
    control = new GUI::TextArea (res->text);
    proptable->add (_("_Text:"), *manage (control));

    /* Page 1: General properties */
    notebook->pages ().push_back (
	Gtk::Notebook_Helpers::TabElem (*manage (proptable),
					_("General")));

    /* Page 2: Buttons */
    notebook->pages ().push_back (
	Gtk::Notebook_Helpers::TabElem (*manage (new ButtonList (res)),
					_("Buttons")));
					
    window.add (*manage (notebook));
    
    res->changed.connect (slot (this, &DialogWindow::update));
    update ();
}

void GUI::DialogWindow::show ()
{
    window.show_all ();
    window.get_window ().raise ();
}

int GUI::DialogWindow::delete_event_impl (GdkEventAny *e)
{
    window.hide ();
    return true;
}

void GUI::DialogWindow::update ()
{
    gchar *title_buf = g_strdup_printf (_("Dialog: %s"), res->id ().c_str ());
    window.set_title (title_buf);
    g_free (title_buf);

    update_block = true;    
    type_combo.set_history (res->dialog_type);
    update_block = false;
}

void GUI::DialogWindow::type_menu_cb (Resources::DialogType type)
{
    res->dialog_type = type;
}
