/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef GF_ACTION_H
#define GF_ACTION_H

#include "gf_display.h"

#define GF_ACTION(obj)	((GfAction *)(obj))

typedef struct _GfAction GfAction;

typedef void (*GfActionFunc)(GfDisplay *display, GdkEventButton *button);

G_BEGIN_DECLS

/* Api */
GfAction *gf_action_new();
void gf_action_destroy(GfAction *action);
void gf_action_set_name(GfAction *action, const gchar *name);
const gchar *gf_action_get_name(GfAction *action);
void gf_action_set_i18n(GfAction *action, const gchar *i18n);
const gchar *gf_action_get_i18n(GfAction *action);
void gf_action_set_func(GfAction *action, GfActionFunc func);
GfActionFunc gf_action_get_func(GfAction *action);
void gf_action_execute(GfAction *action, GfDisplay *display, GdkEventButton *event);
GfAction *gf_action_find_with_name(const gchar *name);
GfAction *gf_action_find_with_i18n(const gchar *i18n);
gint gf_action_get_position(GfAction *action);

/* Sub System */
void gf_actions_init();
void gf_actions_uninit();
void gf_actions_add_action(GfAction *action);
void gf_actions_remove_action(GfAction *action);
gint gf_actions_count();
const gchar *gf_actions_get_nth_name(gint nth);
const gchar *gf_actions_get_nth_i18n(gint nth);

/* Action Functions */
void gf_action_execute_close(GfDisplay *display, GdkEventButton *gdk_event);
void gf_action_execute_open_conv(GfDisplay *display, GdkEventButton *gdk_event);
void gf_action_execute_context(GfDisplay *display, GdkEventButton *gdk_event);
void gf_action_execute_info(GfDisplay *display, GdkEventButton *gdk_event);
void gf_action_execute_log(GfDisplay *display, GdkEventButton *gdk_event);

G_END_DECLS

#endif /* GF_ACTION_H */
