# Gufw 9.10.2 - http://gufw.tuxfamily.org
# Copyright (C) 2009 Marcos Alvarez Costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

 
import time
import commands
from Variable import Variable


class Log:

    def __init__(self):
    
        self.variable = Variable()
        
        self.msgs     = []
        self.wrapping = self.variable.get_constant("disabled")
        self.status   = self.init_status_log()


    # Return status Log (enabled/disabled) and Log recorded
    def init_status_log(self):
        # Get Log Old
        if not self.variable.dev:
            log_recorder = commands.getstatusoutput(self.variable.get_command("get_log_file"))
        else:
            log_recorder = commands.getstatusoutput(self.variable.get_command("get_log_file_dev"))
        
        # File exist
        if log_recorder[0] == 0:
        
            log_split = log_recorder[1].split("\n")
            
            for log_line in log_split:
                if log_line != "":
                    self.msgs.append(log_line)
            
        # Set initial status
        if not self.variable.dev:
            command = commands.getstatusoutput(self.variable.get_command("cfg_gufw_log"))
        else:
            command = commands.getstatusoutput(self.variable.get_command("cfg_gufw_log_dev"))
            
        if command[0] == 0:
            return self.variable.get_constant("gufw_log_on")
        else:
            return self.variable.get_constant("gufw_log_off")

        
    # Add Log
    def add_log(self, status, msg_log):

        if status == self.variable.get_constant("gufw_log_off"):
            return
            
        actual_time = "[" + time.strftime('%x %X') + "] "
        msg  = actual_time + str(msg_log)

        # Append to Log List & Log File
        self.msgs.append(msg)
        
        if not self.variable.dev:
            commands.getstatusoutput(self.variable.get_command("append_log_file").replace("&",msg))
        else:
            commands.getstatusoutput(self.variable.get_command("append_log_file_dev").replace("&",msg))

        
    # Return all log messages
    def get_log(self):
        return self.msgs
        
        
    # Refresh Log
    def refresh_log(self):
        self.msgs = []
        if not self.variable.dev:
            commands.getstatusoutput(self.variable.get_command("refresh_log_file"))
        else:
            commands.getstatusoutput(self.variable.get_command("refresh_log_file_dev"))


    # Set Wrapping
    def set_wrapping(self, wrapping):
        self.wrapping = wrapping
        return wrapping


    # Get Wrapping
    def get_wrapping(self):
        return self.wrapping
