#ifndef SCRIPT_SCANNER_H
#define SCRIPT_SCANNER_H

/*
 * Tester that delegates testing to an external script
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "Mutex.h"
#include "Scanner.h"
#include "ProcessRunner.h"

#include <string>
#include <map>

class ScriptScanner : public Scanner, public ProcessListener
{
protected:
	ProcessRunner runner;
	Mutex candMutex;
	std::map<std::string, const Scan*> scans;

public: 
	ScriptScanner(ProcessRunner runner, ScannerListener* listener) throw ()
		: Scanner(listener), runner(runner) {}
	virtual ~ScriptScanner() throw () {}

	virtual void handleTermination(const std::string& signature, int status) throw ();
	
	void addCandidate(const ScriptScan* scan) throw ();
};

// vim:set ts=4 sw=4:
#endif
