/*
 * Scan for the existance of a DHCP server
 *
 * Copyright (C) 2004  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "DHCPScanner.h"
#include "PacketMaker.h"
#include "Environment.h"
#include "NetBuffer.h"

#include <netinet/in.h> // ntohs, htons, ...

/*
extern "C" {
#include <libnet.h>
}
*/

using namespace std;


void DHCPScanner::handleDHCP(const NetBuffer& dhcp) throw ()
{
	MutexLock lock(candMutex);

	const libnet_dhcpv4_hdr* dhcp_header = dhcp.cast<libnet_dhcpv4_hdr>();

	// Parse and check the DHCP header
	if (dhcp_header->dhcp_opcode == LIBNET_DHCP_REPLY)
	{
		debug("Got DHCP reply\n");
#if 0
		//in_addr* ipv4_him = arp_get_tip(arp_header);
		in_addr* ipv4_him = arp_get_sip(arp_header);
		ether_addr* mac_him = arp_get_sha(arp_header);

		debug("Got ARP reply from %.*s %.*s\n", PFSTR(fmt(IPAddress(*ipv4_him))), PFSTR(fmt(*mac_him)));

		//IPv4_FROM_LIBNET(ipv4_me, arp_header->ar_tpa);
		//IPv4_FROM_ARP(ipv4_him, arp_header->ar_spa);
#endif

		for (list<const DHCPScan*>::const_iterator i = candidates.begin();
				i != candidates.end(); i++)
		{
#if 0
			// Check if IP and MAC addresses match
			if (IPv4_MATCHES(&(*i)->ip(), ipv4_him))
			{
				if (MAC_MATCHES(&(*i)->mac(), mac_him))
				{
					debug("ARP reply from %.*s %.*s matches\n", PFSTR(fmt(IPAddress(*ipv4_him))), PFSTR(fmt(*mac_him)));
					succeeded(*i);
				}
				else
				{
					// If only the IP matches, check if the test is IP-only
					struct ether_addr zeroAddr;
					bzero(&zeroAddr, sizeof(struct ether_addr));
					if (MAC_MATCHES(&(*i)->mac(), &zeroAddr))
					{
						debug("ARP reply from %.*s %.*s matches\n", PFSTR(fmt(IPAddress(*ipv4_him))), PFSTR(fmt(*mac_him)));
						succeeded(*i);
					}
				}
			}
#endif
			succeeded(*i);
		}
	}
}


void DHCPScanner::addCandidate(const DHCPScan* scan)
	throw ()
{
	{
		MutexLock lock(candMutex);
		candidates.push_back(scan);
	}

	// Build and send the DHCP request
	PacketMaker pm(sender);
	Buffer pkt = pm.makeDHCPRequest();

	verbose("Sending 5 DHCP probes, 1 every 2 seconds...\n");

	// Enqueue the packet for sending
	sender.post(pkt, 2000, 10000);
}

// vim:set ts=4 sw=4:
