#include "gtweakui.h"
#include "fileselect.h"

gpointer p[3];
GladeXML *ws; 
GString *old_download_dir;
GConfClient *gc;
guint old_cache_compare;
GSList *userprefs = NULL;

void doquit(gpointer data) {
	GSList *walker;
	for (walker = userprefs; walker; walker = walker->next) {
		g_free(walker->data);
	}
	gt_free(data);
	g_string_free(p[2], TRUE);
	gtk_main_quit();
}

void on_close_clicked(GtkWidget *w, gpointer data) {
	doquit(data);
}

gboolean delete_event(GtkWidget *w, GdkEvent *event, gpointer data) {
	doquit(data);
	return TRUE;
}

void external_downloader_toggled(GtkWidget *w, gpointer d) {
	static GtkWidget *wl[3] = {NULL};
	gboolean state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
	unsigned char x = 0;

	if (wl[0] == NULL) {
		wl[0] = xmlg(d, "external_download_command");
		wl[1] = xmlg(d, "external_download_terminal");
		wl[2] = xmlg(d, "external_download_label");
	}

	for (x = 0; x < 3; x ++) 
		gtk_widget_set_sensitive(wl[x], state);
}

void gnome_mailer_toggled(GtkWidget *w, gpointer d) {
	static GtkWidget *wl[2] = {NULL};
	gboolean state = !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
	unsigned char x = 0;
	
	if (wl[0] == NULL) {
		wl[0] = xmlg(d, "mailer");
		wl[1] = xmlg(d, "gnome_mailer_label");
	}

	for (x = 0; x < 2; x ++) 
		gtk_widget_set_sensitive(wl[x], state);
}

gboolean update_download_dir(const gchar *dir, gboolean nocheck) {
	static GtkWidget *label = NULL;
	gchar *find;

	if (label == NULL)
		label = xmlg(ws, "download_dir_label");

	if (!nocheck && !g_file_test(dir, G_FILE_TEST_IS_DIR))
		return FALSE;

	find = g_strrstr(dir, "/");
	gtk_label_set_text(GTK_LABEL(label), find==NULL?dir:find+1);

	return TRUE;
}

void download_dir_changed(const gchar *new) {
	if (new != NULL)
		if (g_utf8_collate(old_download_dir->str, new) != 0) {
			if (update_download_dir(new, FALSE)) {
				g_string_assign(old_download_dir, new);
				gconf_client_set_string(gc, "/apps/galeon/Handlers/Downloading/download_dir", new, NULL);
			} else {
				GtkWidget *dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _("Error selecting new download folder, please make sure it exists."));
				gtk_dialog_run (GTK_DIALOG (dialog));
				gtk_widget_destroy (dialog);
			}
		}
}

void download_dir_gconf(GConfClient *client, guint cid, GConfEntry *e, gpointer d) {
	if ((gconf_entry_get_value(e) != NULL) && (gconf_entry_get_value(e)->type == GCONF_VALUE_STRING)) {
		const char *new;
		new = gconf_value_get_string(gconf_entry_get_value(e));
		if (g_utf8_collate(old_download_dir->str, new) != 0)
			if (update_download_dir(new, TRUE))
				g_string_assign(old_download_dir, new);
	}
}

void radio_group_toggle(GSList *group, guint button) {
	guint x;
	GSList *head = group;
	for (x = 0; (x < button) && (head->next != NULL); x++)
		head=head->next;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(head->data), TRUE);
}

void cache_compare_changed(GtkWidget *w, gpointer d) {
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)) && (old_cache_compare != (guint)d)) {
		old_cache_compare = (guint)d;
		gconf_client_set_int(gc, "/apps/galeon/Advanced/Network/cache_compare", old_cache_compare, NULL);
	}
}

void cache_compare_gconf(GConfClient *client, guint cid, GConfEntry *e, gpointer d) {
	if ((gconf_entry_get_value(e) != NULL) && (gconf_entry_get_value(e)->type == GCONF_VALUE_INT)) {
		guint new = gconf_value_get_int(gconf_entry_get_value(e));
		if (new != old_cache_compare) {
			old_cache_compare = new;
			radio_group_toggle(d, 3 - new);
		}
	}
}

void initSmooth(GtkWidget *w) {
	GIOChannel *USER;
	GString *line, *filename;
	char *home, *cline;

	filename = g_string_new("");
	
	home=getenv("HOME");
	if (home) {
		g_string_assign(filename, home);
		g_string_append(filename, "/");
	}

	g_string_append(filename, ".galeon/mozilla/galeon/user.js");
	
	USER = g_io_channel_new_file(filename->str, "r", NULL);

	if (USER) {
		line = g_string_new("");
		while (g_io_channel_read_line_string(USER, line, NULL, NULL) == G_IO_STATUS_NORMAL) {
			cline = g_strdup(line->str);
			userprefs = g_slist_append(userprefs, (gpointer)cline);
			if (g_str_has_prefix(line->str, "user_pref(\"general.smoothScroll\", ")) {
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), g_str_has_prefix((char *)(line->str + 34), "true"));
			}
		}
		g_string_free(line, TRUE);
		g_io_channel_unref(USER);
	}
}

void smoothScrollToggled(GtkWidget *w, gpointer d) {
	GIOChannel *USER;
	GString *line, *filename;
	char *home;
	GSList *walker;
	int flag = 0;

	filename = g_string_new("");
	
	home=getenv("HOME");
	if (home) {
		g_string_assign(filename, home);
		g_string_append(filename, "/");
	}

	g_string_append(filename, ".galeon/mozilla/galeon/user.js");
	
	USER = g_io_channel_new_file(filename->str, "w", NULL);

	for (walker = userprefs; walker; walker = walker->next) {
		if (g_str_has_prefix(walker->data, "user_pref(\"general.smoothScroll\", ")) {
			line=g_string_new("user_pref(\"general.smoothScroll\", ");
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
				g_string_append(line, "true");
			else
				g_string_append(line, "false");
			g_string_append(line, ");\n");
			g_io_channel_write_chars(USER, line->str, -1, NULL, NULL);
			g_string_free(line, TRUE);
			flag=1;
		} else {
			g_io_channel_write_chars(USER, walker->data, -1, NULL, NULL);
		}
	}
	if (flag == 0) {
		line=g_string_new("user_pref(\"general.smoothScroll\", ");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
			g_string_append(line, "true");
		else
			g_string_append(line, "false");
		g_string_append(line, ");\n");
		g_io_channel_write_chars(USER, line->str, -1, NULL, NULL);
		g_string_free(line, TRUE);
	}
	g_io_channel_unref(USER);
}

void hookupcallbacks() {
	GConfValue *gv;
	GSList *prefs = NULL;

	gc = gconf_client_get_default();
	gconf_client_add_dir(gc, "/apps/galeon/Advanced/Filtering", GCONF_CLIENT_PRELOAD_NONE, NULL);
	gconf_client_add_dir(gc, "/apps/galeon/Advanced/Network", GCONF_CLIENT_PRELOAD_NONE, NULL);
	gconf_client_add_dir(gc, "/apps/galeon/Browsing/History", GCONF_CLIENT_PRELOAD_NONE, NULL);
	gconf_client_add_dir(gc, "/apps/galeon/Handlers/Downloading", GCONF_CLIENT_PRELOAD_NONE, NULL);
	gconf_client_add_dir(gc, "/apps/galeon/Handlers/Programs", GCONF_CLIENT_PRELOAD_NONE, NULL);
	gconf_client_add_dir(gc, "/apps/galeon/UI/Tabs", GCONF_CLIENT_PRELOAD_NONE, NULL);

	xsc(ws, "close_button", "clicked", on_close_clicked, prefs);
	xsc(ws, "about_button", "clicked", about, xmlg(ws, "nautilus"));
	xsc(ws, "galeon", "delete_event", delete_event, prefs);

	prefs = gt_add_bool(prefs, gc, "/apps/galeon/Advanced/Filtering/default_allow_statusbar", xmlg(ws, "default_allow_statusbar"));
	prefs = gt_add_bool(prefs, gc, "/apps/galeon/Browsing/History/completion_show_list_auto", xmlg(ws, "completion_show_list_auto"));
	prefs = gt_add_bool(prefs, gc, "/apps/galeon/Browsing/History/completion_show_titles", xmlg(ws, "completion_show_titles"));
	prefs = gt_add_bool(prefs, gc, "/apps/galeon/Handlers/Downloading/ask_for_download_dir", xmlg(ws, "ask_for_download_dir"));
	prefs = gt_add_bool(prefs, gc, "/apps/galeon/Handlers/Downloading/external_downloader", xmlg(ws, "external_downloader"));
	prefs = gt_add_bool(prefs, gc, "/apps/galeon/Handlers/Downloading/external_download_terminal", xmlg(ws, "external_download_terminal"));
	prefs = gt_add_bool(prefs, gc, "/apps/galeon/Handlers/Programs/gnome_mailer", xmlg(ws, "gnome_mailer"));
	prefs = gt_add_string(prefs, gc, "/apps/galeon/Handlers/Downloading/external_download_command", xmlg(ws, "external_download_command"));
	prefs = gt_add_string(prefs, gc, "/apps/galeon/Handlers/Programs/mailer", xmlg(ws, "mailer"));
	prefs = gt_add_int(prefs, gc, "/apps/galeon/Browsing/History/expire", xmlg(ws, "expire"), 10000);
	prefs = gt_add_color(prefs, gc, "/apps/galeon/UI/Tabs/tabbed_new_color", xmlg(ws, "tabbed_new_color"));
	prefs = gt_add_color(prefs, gc, "/apps/galeon/UI/Tabs/tabbed_loading_color", xmlg(ws, "tabbed_loading_color"));
	prefs = gt_add_intmenu(prefs, gc, "/apps/galeon/UI/Tabs/tabbed_position", xmlg(ws, "tabbed_position"));

	external_downloader_toggled(xmlg(ws, "external_downloader"), ws);
	gnome_mailer_toggled(xmlg(ws, "gnome_mailer"), ws);

	old_download_dir = g_string_new(gconf_client_get_string(gc, "/apps/galeon/Handlers/Downloading/download_dir", NULL));
	p[0] = (gpointer *)download_dir_changed;
	p[1] = (gpointer *)old_download_dir;
	p[2] = g_string_new(_("Please select a new download folder"));

	gconfc(gc, "/apps/galeon/Handlers/Downloading/download_dir", download_dir_gconf, NULL);

	update_download_dir(old_download_dir->str, TRUE);

	xsc(ws, "download_dir", "clicked", dirselect, p);
	xsc(ws, "external_downloader", "toggled", external_downloader_toggled, ws);
	xsc(ws, "gnome_mailer", "toggled", gnome_mailer_toggled, ws);

	old_cache_compare = gconf_client_get_int(gc, "/apps/galeon/Advanced/Network/cache_compare", NULL);
	radio_group_toggle(gtk_radio_button_get_group(GTK_RADIO_BUTTON(xmlg(ws, "cache_compare0"))), 3 - old_cache_compare);

	xsc(ws, "cache_compare0", "toggled", cache_compare_changed, (gpointer)0);
	xsc(ws, "cache_compare1", "toggled", cache_compare_changed, (gpointer)1);
	xsc(ws, "cache_compare2", "toggled", cache_compare_changed, (gpointer)2);
	xsc(ws, "cache_compare3", "toggled", cache_compare_changed, (gpointer)3);
	gconfc(gc, "/apps/galeon/Advanced/Network/cache_compare", cache_compare_gconf, gtk_radio_button_get_group(GTK_RADIO_BUTTON(xmlg(ws, "cache_compare0"))));

	initSmooth(xmlg(ws, "smoothScroll"));
	xsc(ws, "smoothScroll", "toggled", smoothScrollToggled, NULL);

	gtk_widget_show_all(xmlg(ws, "galeon"));
}

int main(int argc, char *argv[]) {
	gtweakui = gnome_program_init(PACKAGE_NAME, PACKAGE_VERSION, LIBGNOMEUI_MODULE, argc, argv, GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR, NULL);
	gconf_init(argc, argv, NULL);
	
	bindtextdomain (GETTEXT_PACKAGE, GTWEAKUILOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	ws = glade_xml_new(gnome_program_locate_file(gtweakui, GNOME_FILE_DOMAIN_APP_DATADIR, "galeon.glade", FALSE, NULL), NULL, NULL);

	hookupcallbacks();

	gtk_main();

	return 0;
}
