/* this file implements gnometoasters preview function which can be used
 * to listen to audio tracks prior to writing them to a cd,be it to test
 * wether the track sounds properly or just to determine if it is the right
 * track at all. This widget primarily works as a drop destination where
 * tracks to be previewed are dropped. Additionally,it implements
 * a button to stop a tracks preview if it is no longer needed.
 *
 * It is intended to support a variety of output devices with a driver-based
 * concept. That means,that well have to create a driver database for audio
 * output,supporting at least esd and dsp from the very beginning.
 *
 * concerning docking position,we should possibly allow it to float around freely
 * if gnome support is enabled,perhaps giving it the layout of a proper
 * media player if dragged outside Gnometoasters main window */

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

#include "int.h"

#include "main.h"
#include "tracks.h"
#include "preview.h"
#include "dndsetup.h"
#include "fileman.h"
#include "dirlow.h"
#include "stdfiletrack.h"
#include "streams.h"
#include "audio.h"
#include "helpings.h"
#include "cddrives.h"
#include "streamcopy.h"
#include "dialog.h"

#include "playtrack.xpm"
#include "stopplayer.xpm"

/* uncomment for debugging */
/* #define DEBUG */

/* record.c checks this var before it initiates the writing process
 * as the precious timing necessary for a flawless writing procedure
 * is likely to be disturbed by the playing process */
int preview_player_active=0;

GtkWidget *icon_playtrack;
GtkWidget *icon_stopplayer;

void preview_startplayer(preview_infostruct *info,
			 tracks_trackinfo *track);

preview_infostruct preview_info;

void preview_doneplaying(streamcopy_state *cs,
			 preview_infostruct *info)
{
#ifdef DEBUG
   printf ("preview_stopplay: closing track\n");
#endif
   tracks_closepipe(info->currenttrack);
#ifdef DEBUG
   printf ("preview_stopplay: closing audio driver\n");
#endif
   audio_close(info->driver);

#ifdef DEBUG
   printf ("preview_stopplay: unclaiming track\n");
#endif
   tracks_unclaim(info->currenttrack);

   info->currenttrack=NULL;
   info->cs=NULL;

   /* change icon of the preview player button */
   gtk_widget_show(icon_playtrack);
   gtk_widget_hide(icon_stopplayer);

   preview_player_active=0;

   if (info->nexttrack)
     {
	preview_startplayer(info,info->nexttrack);
	info->nexttrack=NULL;
     };
};

void preview_stopplayer(GtkWidget *w,
			preview_infostruct *info)
{
   if (info->cs!=NULL)
     streamcopy_cancel(info->cs);
};

void preview_startplayer(preview_infostruct *info,
			 tracks_trackinfo *track)
{
   /* play audio tracks only
    * and check if track is valid */

   if ((!strcmp(track->tracktype,"audio"))&&(tracks_valid(track)))
     {
	int input;
	int output;

	info->currenttrack=track;
	/* get the audio device currently responsible for output */
	info->driver=audio_getdriver_default;

#ifdef DEBUG
	printf ("preview_startplayer: opening audio driver ");
#endif
	/* open audio device */
	output=audio_open(info->driver);
	if (output==-1)
	  {
	     char *estr=strerror(errno);
	     char *message=malloc(1024+strlen(estr));
	     sprintf(message,_("The selected audio driver couldn't be initialized\n"
			       "Please make sure your sound hardware is configured\n"
			       "properly, all drivers have been loaded and access permissions have\n"
			       "been set properly.\n"
			       "The error message as received from the Operating System was:\n"
			       "'%s'\n")
		     ,estr);
	     dialog_error(message);
	     free(message);
	  };

#ifdef DEBUG
	printf ("(result=%i)\n",output);
	printf ("preview_startplayer: opening audio track ");
#endif
	/* open track */
	input=tracks_openpipe(info->currenttrack);

#ifdef DEBUG
	printf ("(result=%i)\n",input);
	printf ("preview_droptrack: installing data forwarding handler\n");
#endif
	
	/* change icon of the preview player button */
	gtk_widget_show(icon_stopplayer);
	gtk_widget_hide(icon_playtrack);

	preview_player_active=1;
	
	info->cs=streamcopy_create(output,
				   input,
				   -1,
				   -1, /* no valid tracksize, we won't do any padding so this does not matter */
				   NULL,
				   0,
				   (streamcopy_callback)preview_doneplaying,
				   info);
     }
   else
     {
	tracks_unclaim(track);
#ifdef DEBUG
	printf ("preview_startplayer: not playing non-audio track\n");
#endif
     };
};

int preview_droptrack(char *s,char *p,
		      fileman_mkdircall mkdir,
		      fileman_addfilecall addfile,
		      gpointer data
		      )
{
   preview_infostruct *info;
   tracks_trackinfo *nt=NULL;

   info=(preview_infostruct*)p;

#ifdef DEBUG
   printf ("preview_droptrack: check if another track is in process\n");
#endif
   /* distinguish between real tracks and files that have to be
    * converted first */
   if (!strncmp("stream:",s,7))
     {
#ifdef DEBUG
	printf ("preview_droptrack: found normal track stream\n");
#endif
	nt=streams_getstreambyid((char*)(strchr(s,':')+1));
	/* claim if valid only */
	if (nt!=NULL)
	  tracks_claim(nt);
     }
   else
     {	
	/* everything that's not a stream will be treated as a file ;-) */
#ifdef DEBUG
	printf ("preview_droptrack: found file,executing file2track conversion\n");
#endif
	nt=stdfiletrack_create(s);
     };

   /* just ignore everything that is neither stream nor file...
    * also ignore streams that came from outside as long as they arent
    * substituted with some kind of "remote track" type in
    * streams_getstreambyid */
   if (nt!=NULL)
     {
	/* if were currently playing a track,stop it before starting a new one */
	if (info->cs!=NULL)
	  {
	     if (!info->nexttrack)
	       {
		  info->nexttrack=nt;
		  /* stop playing current song.
		   * the donecb handler of the preview player will
		   * the automatically start up info->nexttrack if this
		   * entry is !=NULL */
		  streamcopy_cancel(info->cs);
	       }
	     else
	       /* we can't store it, we can't play it.
		* Don't have any more use of it. */
	       tracks_unclaim(nt);
	  }
	else
	  preview_startplayer(info,nt);
     }
   else
     {
#ifdef DEBUG
	printf ("preview_droptrack: couldnt get valid track structure\n");
#endif
     };
   return 1;
};

/* process drops */
int preview_droptracks(const gchar *selection,
		       int x,int y,
		       int dragtype,
		       gpointer data)
{
   GList *drops=helpings_convertdndlist(selection);
   preview_infostruct *info=data;
   if (drops!=NULL)
     {
	/* we only accept the first item dropped on the preview player */
	preview_droptrack((char*)drops->data,
			  (char*)info,
			  NULL,NULL,
			  NULL);
	helpings_freestringlist(drops);
     };
   return 1;
};

/* use this interface to initiate track playing from other parts of
 * Gnometoaster
 * The second parameter is the media player infostruct. It usually points
 * to preview_info at the moment,so youre probably ok if you just
 * give it &preview_info there */
void preview_playtrack(char *trackname,preview_infostruct *info)
{
#ifdef DEBUG
   printf ("preview_playtrack: dropping track %s\n",trackname);
#endif
   preview_droptrack(trackname,(char*)info,NULL,NULL,NULL);
};

void preview_create()
{
   GdkPixmap *xpm;
   GdkBitmap *mask;
   GtkStyle  *style;

   style=gtk_widget_get_style(window);
   xpm=gdk_pixmap_create_from_xpm_d(window->window,&mask,
				    &style->bg[GTK_STATE_NORMAL],
				    playtrack_xpm
				    );
   icon_playtrack=gtk_pixmap_new(xpm,mask);
   xpm=gdk_pixmap_create_from_xpm_d(window->window,&mask,
				    &style->bg[GTK_STATE_NORMAL],
				    stopplayer_xpm
				    );
   icon_stopplayer=gtk_pixmap_new(xpm,mask);

   preview_info.button=gtk_button_new();
   preview_info.iconholder=gtk_vbox_new(0,0);
   gtk_container_add(GTK_CONTAINER(preview_info.button),
		     preview_info.iconholder);
   gtk_widget_show(preview_info.iconholder);
   gtk_widget_show(preview_info.button);
   main_settip(preview_info.button,_("Drag files/tracks to be previewed here"));

   /* add both icons to the button but show only one of them at a time */
   gtk_box_pack_start(GTK_BOX(preview_info.iconholder),icon_playtrack,0,0,0);
   gtk_box_pack_start(GTK_BOX(preview_info.iconholder),icon_stopplayer,0,0,0);
   gtk_widget_show(icon_playtrack);

   /* register preview widget as drop destination */
   dndsetup_drop(preview_info.button,
		 preview_droptracks,
		 &preview_info);

   gtk_signal_connect(GTK_OBJECT(preview_info.button),"clicked",
		      GTK_SIGNAL_FUNC(preview_stopplayer),&preview_info);

   gtk_box_pack_end(GTK_BOX(downbox),preview_info.button,0,0,0);

   preview_info.currenttrack=NULL;
   preview_info.cs=NULL;
   preview_info.nexttrack=NULL;

};

void preview_destroy()
{
   preview_stopplayer(NULL,
		      &preview_info);
};

