/* this file contains handling routines and 
 * data structures for multisession */

#ifndef MULTISESSION_H
#define MULTISESSION_H

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>

#include "virtualdir.h"
#include "varman.h"
#include "preferences.h"
#include "fileman.h"

/* contains the directory structure of the last session or NULL if not
 * present */
extern virtualdir_dir *multisession_lastsession;
extern GList *multisession_updatehandlers;

/* import the last session of a ms cd */
void multisession_import();
/* delete ms informations */
void multisession_delete();

#endif // MULTISESSION_H
