/* This file implements the various input widgets for the preferences 
 * of Gnome Toaster. The most important thing about those widgets is that
 * all of them take a varman variable as argument,which is then directly
 * affected by any changes done to the input widget. */

/* IMPORTANT: input widgets must provide two different ways of processing 
 * informations. first:  apply all changes to the referring vars immediately.
 *               second: only apply changes when a special signal is received.*/

#include <stdlib.h>
#include <gtk/gtk.h>

#include "varman.h"
#include "varmanwidgets.h"
#include "preferences.h"

/* uncomment for debugging */
/* #define DEBUG */

void varmanwidgets_entry_apply(GtkWidget *w,
			       varmanwidgets_widget *d)
{
	varman_setvar(d->database,d->varname,gtk_entry_get_text(GTK_ENTRY(d->edit)));
}
;

/* this is getting called from different places:
 *  1) used as a varman update callback.
 *     *w is *not* a pointer to a widget but a pointer to a varman
 *     var structure in this case - doesn't matter as we don't
 *     use this parameter.
 *  2) as an in-widget updater when the "Undo" Button is clicked.
 *     *w will be a pointer to the "undo" button's widget in this
 *     case. We don't need this. */
void varmanwidgets_entry_undo(GtkWidget *w,
			       varmanwidgets_widget *d)
{
	gtk_entry_set_text(GTK_ENTRY(d->edit),varman_getvar(d->database,d->varname));
}
;

void varmanwidgets_entry_txtch(GtkWidget *w,GdkEventKey *e,varmanwidgets_widget *d)
{
	varmanwidgets_entry_apply(w,d);
}
;

varmanwidgets_widget *varmanwidgets_entry_new(char *label,
					      char *var,
					      varman_database *database,
					      int apply_mode,
					      int labelsize,
					      int editsize)
{
   GtkWidget *al;
   
   varmanwidgets_widget *widget;
		
   widget=(varmanwidgets_widget*)malloc(sizeof(varmanwidgets_widget));
	
   widget->visual=gtk_hbox_new(0,0);

   al=gtk_alignment_new(0,0.5,0,0);
   gtk_widget_show(al);
   widget->label=gtk_label_new(label);
   if (labelsize>0)
     gtk_widget_set_usize(widget->label,labelsize,-1);
   gtk_label_set_justify(GTK_LABEL(widget->label),
			 GTK_JUSTIFY_LEFT);
   gtk_widget_show(widget->label);
   gtk_container_add(GTK_CONTAINER(al),widget->label);
   gtk_box_pack_start(GTK_BOX(widget->visual),al,0,1,1);
	
	widget->edit=gtk_entry_new();	
	gtk_entry_set_text(GTK_ENTRY(widget->edit),varman_getvar(database,var));
   	gtk_entry_set_position(GTK_ENTRY(widget->edit),0);
	gtk_widget_set_usize(widget->edit,editsize,-1);
	gtk_widget_show(widget->edit);
	gtk_box_pack_start(GTK_BOX(widget->visual),widget->edit,0,0,0);
	
	gtk_widget_show(widget->visual);
	
	widget->database=database;
	strcpy(widget->varname,var);

   	varman_install_handler(database,var,
			       (varman_varchanged)varmanwidgets_entry_undo,
			       (gpointer)widget
			       );
   
	switch (apply_mode)
	  {
	  case APPLYMODE_ALWAYS:
		  gtk_signal_connect(GTK_OBJECT(widget->edit),"key_press_event",
				     varmanwidgets_entry_txtch,widget);
		  break;
	  case APPLYMODE_BUTTON:
		  preferences_setapplyhandler(varmanwidgets_entry_apply,widget);
		  preferences_setundohandler(varmanwidgets_entry_undo,widget);
		  break;
	  }
	;	
	return widget;
}
;

void varmanwidgets_checkbox_apply(GtkWidget *w,
				  varmanwidgets_widget *d)
{
	varman_setvar(d->database,d->varname,
		      (GTK_TOGGLE_BUTTON(d->edit)->active)?d->activetext
		                                          :d->inactivetext);
}
;

void varmanwidgets_checkbox_undo(GtkWidget *w,
			       varmanwidgets_widget *d)
{
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(d->edit),
				     (!strcmp(varman_getvar(d->database,d->varname),
					      d->activetext))?1:0);
}
;

varmanwidgets_widget *varmanwidgets_checkbox_new(char *label,
						 char *var,
						 varman_database *database,
						 int apply_mode,
						 int labelsize,
						 char *activetext,
						 char *inactivetext)
{
	varmanwidgets_widget *widget;
		
	widget=(varmanwidgets_widget*)malloc(sizeof(varmanwidgets_widget));
	
	widget->visual=gtk_hbox_new(0,0);
		
	widget->edit=gtk_check_button_new_with_label(label);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget->edit),
				     (!strcmp(varman_getvar(database,var),activetext))?1:0);
	gtk_widget_show(widget->edit);
	gtk_box_pack_start(GTK_BOX(widget->visual),widget->edit,0,0,0);
	
	gtk_widget_show(widget->visual);
	
	widget->database=database;
	strcpy(widget->varname,var);
	strcpy(widget->activetext,activetext);
	strcpy(widget->inactivetext,inactivetext);	
	
   	varman_install_handler(database,var,
			       (varman_varchanged)varmanwidgets_checkbox_undo,
			       (gpointer)widget
			       );
   
	switch (apply_mode)
	  {
	  case APPLYMODE_ALWAYS:
		  gtk_signal_connect(GTK_OBJECT(widget->edit),"clicked",
				     varmanwidgets_checkbox_apply,widget);
		  break;
	  case APPLYMODE_BUTTON:
		  preferences_setapplyhandler(varmanwidgets_checkbox_apply,widget);
		  preferences_setundohandler(varmanwidgets_checkbox_undo,widget);
		  break;
	  }
	;	
	return widget;
}
;

void varmanwidgets_combo_apply(GtkWidget *w,
			       varmanwidgets_widget *d)
{
	varman_setvar(d->database,d->varname,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(d->edit)->entry)));
}
;

void varmanwidgets_combo_undo(GtkWidget *w,
			       varmanwidgets_widget *d)
{
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(d->edit)->entry),varman_getvar(d->database,d->varname));
}
;

void varmanwidgets_combo_txtch(GtkWidget *w,GdkEventKey *e,varmanwidgets_widget *d)
{
	varmanwidgets_combo_apply(w,d);
}
;

varmanwidgets_widget *varmanwidgets_combo_new(char *label,
					      char *var,
					      varman_database *database,
					      int apply_mode,
					      int labelsize,
					      GList *popdown)
{
	varmanwidgets_widget *widget;
		
	widget=(varmanwidgets_widget*)malloc(sizeof(varmanwidgets_widget));
	
	widget->visual=gtk_hbox_new(0,0);
	
	widget->label=gtk_label_new(label);
	if (labelsize>0)
	    gtk_widget_set_usize(widget->label,labelsize,-1);
	gtk_label_set_justify(GTK_LABEL(widget->label),GTK_JUSTIFY_LEFT);
	gtk_widget_show(widget->label);
	gtk_box_pack_start(GTK_BOX(widget->visual),widget->label,0,0,0);
	
	widget->edit=gtk_combo_new();	
   	if (popdown!=NULL)
        	gtk_combo_set_popdown_strings(GTK_COMBO(widget->edit),popdown);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(widget->edit)->entry),
			   varman_getvar(database,var));
	gtk_widget_show(widget->edit);
	gtk_widget_set_usize(widget->edit,320,-1);
	gtk_box_pack_start(GTK_BOX(widget->visual),widget->edit,0,0,0);
	
	gtk_widget_show(widget->visual);
	
	widget->database=database;
	strcpy(widget->varname,var);
	
   	varman_install_handler(database,var,
			       (varman_varchanged)varmanwidgets_combo_undo,
			       (gpointer)widget
			       );
   
	switch (apply_mode)
	  {
	  case APPLYMODE_ALWAYS:
		  gtk_signal_connect(GTK_OBJECT(widget->edit),"activate",
				     varmanwidgets_combo_txtch,widget);
		  break;
	  case APPLYMODE_BUTTON:
		  preferences_setapplyhandler(varmanwidgets_combo_apply,widget);
		  preferences_setundohandler(varmanwidgets_combo_undo,widget);
		  break;
	  }
	;	
	return widget;
}
;

void varmanwidgets_spin_apply(GtkWidget *w,
			      varmanwidgets_widget *d)
{
#ifdef DEBUG
   printf ("varmanwidgets_spin_apply: setting var %s\n",	   
	   d->varname     
	   );   
   printf ("varmanwidgets_spin_apply: to value %f\n",   
	   gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(d->edit))	     	   
	   );
#endif
   varman_setvar_value(d->database,
		       d->varname,
		       gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(d->edit)));
}
;

void varmanwidgets_spin_undo(GtkWidget *w,
			     varmanwidgets_widget *d)
{
   	gtk_spin_button_set_value(GTK_SPIN_BUTTON(d->edit),
				  varman_getvar_value(d->database,d->varname));
}
;

varmanwidgets_widget *varmanwidgets_spin_new(char *label,
					     char *var,
					     varman_database *database,
					     int apply_mode,
					     int labelsize,
					     GtkAdjustment *adj
					     )
{
	varmanwidgets_widget *widget;
        float currentspeed;
		
	widget=(varmanwidgets_widget*)malloc(sizeof(varmanwidgets_widget));
	
	widget->visual=gtk_hbox_new(0,0);
	
	widget->label=gtk_label_new(label);
	if (labelsize>0)
	    gtk_widget_set_usize(widget->label,labelsize,-1);
	gtk_label_set_justify(GTK_LABEL(widget->label),GTK_JUSTIFY_LEFT);
	gtk_widget_show(widget->label);
	gtk_box_pack_start(GTK_BOX(widget->visual),widget->label,0,0,0);
	
	widget->edit=gtk_spin_button_new(adj,0.5,0);
   	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(widget->edit),1);   
	gtk_widget_show(widget->edit);
	gtk_box_pack_start(GTK_BOX(widget->visual),widget->edit,0,0,0);
	
	gtk_widget_show(widget->visual);
	
	widget->database=database;
	strcpy(widget->varname,var);
	
   	currentspeed=varman_getvar_value(widget->database,widget->varname);
   	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget->edit),
				  currentspeed);
   
   	varman_install_handler(database,var,
			       (varman_varchanged)varmanwidgets_spin_undo,
			       (gpointer)widget
			       );
   
	switch (apply_mode)
	  {
	  case APPLYMODE_ALWAYS:
		  gtk_signal_connect(GTK_OBJECT(adj),"value_changed",
				     varmanwidgets_spin_apply,widget);
		  break;
	  case APPLYMODE_BUTTON:
		  preferences_setapplyhandler(varmanwidgets_spin_apply,widget);
		  preferences_setundohandler(varmanwidgets_spin_undo,widget);
		  break;
	  }
	;	
	return widget;
}
;
	
	
	
	
	
	
