/* The recording terminal */

#include <gtk/gtk.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>

#include "int.h"

#include "colors.h"
#include "wheel.h"
#include "rterm.h"

GtkWidget *rterm_terminal; // the output Terminal

void rterm_pipe2term(gpointer i,
		     int source,
		     GdkInputCondition condition)
{
	char buf;
	rterm_pipeinfo *info;
	
	info=(rterm_pipeinfo*)i;
	while (read(info->filedes,&buf,1)==1) rterm_outc((*info->color),&buf);
}
;

rterm_pipeinfo *rterm_connectpipe(GdkColor *col,int f) // connect a pipe to the Terminal
{
	rterm_pipeinfo *info;

	info=(rterm_pipeinfo*)malloc(sizeof(rterm_pipeinfo));
	info->filedes=f;
	info->color=col;
	
	fcntl(info->filedes,F_SETFL,O_NONBLOCK);
	info->tag=gdk_input_add(info->filedes,
				  GDK_INPUT_READ,
				  rterm_pipe2term,
				  info);
	return info;
}
;

void rterm_disconnectpipe(rterm_pipeinfo *info)
{
	gtk_input_remove(info->tag);
	free(info);
}
;

GtkWidget *rterm_create()
{
	GtkWidget *frame;
	GtkWidget *hbox;
	GtkWidget *scrolling;

	frame=gtk_frame_new(_("Client output"));

	hbox=gtk_hbox_new(0,0);
	
	rterm_terminal=gtk_text_new(NULL,NULL);
	gtk_text_set_editable(GTK_TEXT(rterm_terminal),0);
	gtk_text_set_word_wrap(GTK_TEXT(rterm_terminal),1);
        gtk_box_pack_start(GTK_BOX(hbox),rterm_terminal,1,1,1);
	gtk_widget_show(rterm_terminal);
	
	scrolling=gtk_vscrollbar_new(GTK_TEXT(rterm_terminal)->vadj);	
	gtk_box_pack_start(GTK_BOX(hbox),scrolling,0,0,0);
	gtk_widget_show(scrolling);
	
	wheel_connect(rterm_terminal,GTK_TEXT(rterm_terminal)->vadj,4);
	
	gtk_container_add(GTK_CONTAINER(frame),hbox);
	gtk_widget_show(hbox);
	
	rterm_printcln(Blue,_("GnomeToaster Recording Terminal"));
	
	return frame;
}
;
	
	
	
	
