/* tools.cpp

  Created by SMF aka Antoine Laydier (laydier@usa.net)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

/*=============================================================================
  HEADERs
 =============================================================================*/
#include "mp3tools.h"
#include <string.h>

/*=============================================================================
 Class : Tools
 =============================================================================*/
void Tools::safecopy(char *to, char *from, int maxlen)
{
    int where;
    strncpy(to, from, maxlen);
    to[maxlen] = 0;
    for (where = maxlen - 1; ((where >= 0) && (to[where] == ' ')); where--) {
	to[where] = 0;
    }
}

void Tools::spacecopy(char *to, char *from, int maxlen)
{
    int where;
    strncpy(to, from, maxlen);
    for (where = maxlen - 1; ((where >= 0) && (to[where] == 0)); where--) {
	to[where] = ' ';
    }
}
