/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Aug 17 11:30:38 CEST 1999
    last modified        : Thu Jan  4 20:40:10 CEST 2001                                           
    copyright            : (C) 2000 by Panagiotis Issaris                         
    email                : panagiotis.issaris@advalvas.be, 
                           takis@lumumba.luc.ac.be

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define AVI_VIDEO_FRAMES 48
#define AVI_VIDEO_FRAMES_SIZEOF 4
#define AVI_VIDEO_XRES 64
#define AVI_VIDEO_XRES_SIZEOF 4
#define AVI_VIDEO_YRES 68
#define AVI_VIDEO_YRES_SIZEOF 4
#define AVI_VIDEO_CODEC 112
#define AVI_VIDEO_CODEC_SIZEOF 5
#define AVI_VIDEO_BPP 194
#define AVI_VIDEO_BPP_SIZEOF 2
#define AVI_AUDIO_RATE 324

struct avi_video
{
	int frames;
	char f1[12];
    int xres;
	int yres;
	char f2[40];
	char codec[5];
	char f3[77];
	short bpp;
};

struct avi_audio
{
	char f1[128];
	int rate;
};

struct avi
{
	struct avi_video video;
	struct avi_audio audio;
};

char* version="0.1";
char* author="Panagiotis Issaris";
char* email="panagiotis.issaris@advalvas.be";
char* pluginname="aviinfo";
char* date="2000";

void strtolower(char* str)
{
   int i=0;
   while (str[i] != '\0')
   {
      str[i]=tolower(str[i]);
      i++;
   }
}

void simplify(char* ret,char* data)
{
    char** point;
    char* substring;

    point=&data;
    while ((substring=strsep(point,"\n")) != 0)
    {
	strncpy(ret+strlen(ret),substring,strlen(substring));
    }
}

char* const getAVIInfo(FILE* f)
{
   char* ret=0;
	struct avi a;
	fseek(f,48,SEEK_SET);
	fread(&a,sizeof(a),1,f);
    ret = (char*) malloc(64);
	if((a.video.frames<=0)||(a.video.xres<=0)||(a.video.yres<=0))
	{

/* Do you want errormessages to waste space in your catalog file? */
#if 0
	    sprintf(ret, "Unrecognised AVI format");
#else

		free(ret);
		ret=0;
#endif
		return ret;
	}
	sprintf(ret, "%dx%d, %d frames, %s", a.video.xres, a.video.yres,a.video.frames,a.video.codec);
   return ret;
}

void info()
{
	printf("%s %s(C) %s %s <%s>\n", pluginname, version, date, author, email);
	printf("AVI Info extraction plugin for the GTKtalog project\n");
}

int main(int argc, char** argv)
{
	char* data;
	FILE *f;
	
	if ((!strcmp(argv[argc - 1],"--help"))||(argc==1))
	{
		info();
		exit(0);
	}
	else
	{
  		if ((f=fopen(argv[1],"r")) != 0)
  		{
  		   data=getAVIInfo(f);
  		   if (data != 0)
  		   {
  		      printf("%s\n", data);
  		      free(data);
  		   }
  		    else
  		    {
		    	printf("\n");
			}
  		    fclose(f);
  		}
  		else
  		{
		    	printf("\n");
  		}
  	}
}
