/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#if defined(OS_FREEBSD) || defined(OS_NETBSD) || defined(OS_OPENBSD)
#    include <sys/param.h>
#    include <sys/mount.h>
#endif
#include <gnome.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <regex.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/mtio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#if defined(USE_PTHREADS)
#    include <pthread.h>
#endif
#include <sys/mtio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#if defined(OS_LINUX)
#    include <linux/cdrom.h>
#endif

#include "addisk.h"
#include "config_common.h"
#include "compare.h"
#include "folder.h"
#include "io.h"
#include "interface.h"
#include "fastaddisk.h"
#include "progressbar.h"
#include "thread_utils.h"

#ifdef LIBC5
#define SIGUSR1 SIGSTKFLT
#define SIGUSR2 SIGUNUSED
#endif

GtkWidget *name_entry;

#if defined(USE_PTHREADS)
static pthread_t thread1;
#endif

/*
 * Takes a device name for input, and returns its volume name.
 * allocates 32+1 bytes for the return buffer.
 */
char *
get_disk_label (char *dev_name)
{
#if defined(OS_LINUX)
  struct stat statbuf;
  FILE *inf;

  if (stat (dev_name, &statbuf))
    return NULL;

  if (S_ISREG (statbuf.st_mode))
    return NULL;

  if ((inf = fopen (dev_name, "rb")))
    {
      gchar *buf, *buf1;
      int status = 0;

      /* (comments by David Erman <di97der@student.hk-r.se>)
       * Why 32808 bytes? Well, after doing a:
       * 
       *  dd count=70 if=/dev/cdrom
       * 
       * that's where I found the title of the CD
       *  basically. I couldn't find any docs on the
       *  ISO9660 filesystem, so I'm not sure why this is
       *  but it seems to be a consistent value. Looks
       *  like it might be the fs header there, since
       *  there is info on the creator and such as well.
       *  
       *  Thus, we fseek 32808 bytes, which will amount to
       *  16 2048-byte blocks; 2048 byte blocks are used on
       *  ISO9660 CD's right?
       *
       *  I'm not sure this'll work on HFS CD's, but there you go.
       */

      status = fseek (inf, 32808, SEEK_SET);
      if (status != 0)
	{
	  fclose (inf);
	  return NULL;
	}

      buf = (gchar *) g_malloc (MAX_DISK_LABEL_LENGTH + 1);
      status = fread (buf, MAX_DISK_LABEL_LENGTH, 1, inf);

      fclose (inf);
      if (status != 1)
	return NULL;

      /* pretty-print the label to a string with maximum length of 32 */
      buf1 = g_strdup_printf ("%.32s", buf);
      g_free (buf);
      /* remove trailing spaces from label name */
      return g_strchomp (buf1);
    }
  else
    {
      return NULL;
    }
#elif defined(OS_PPC_DARWIN)
  gchar *dum, *label;

  dum = mosx_get_cd_mount_point (TRUE);
  if (dum != NULL)
    {
      label = g_strdup (dum + 9);
      g_free (dum);
      return label;
    }
  else
    return NULL;

#else
  return NULL;
#endif
}

int
fad_create_window (gchar ** fast_name, FOLDER * racine)
{
  GtkWidget *name_window;
  GtkWidget *frame, *box;
  int button;
  gboolean name_ok = FALSE;
  gint ret = -1;
  GtkWidget *warning = NULL;

  if ((my_config->read_cd_name) && (!my_config->validate_cd_name)
      && (fast_name[0]) && (strcmp (fast_name[0], "")))
    return (1);
  /* Window */
  name_window = gnome_dialog_new (_("Set disk name"),
				  GNOME_STOCK_BUTTON_OK,
				  GNOME_STOCK_BUTTON_CANCEL, NULL);

  /* FIXME: Set Parent to help the window manager */
  //gnome_dialog_set_parent(GNOME_DIALOG(dlg), GTK_WINDOW(app));

  gtk_window_set_position (GTK_WINDOW (name_window), GTK_WIN_POS_MOUSE);

  /* Label */
  frame = gtk_frame_new (_("Disk Label"));
  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (name_window)->vbox), frame,
		      TRUE, TRUE, 0);
  gtk_widget_show (frame);

  /* Name of the Disk */
  name_entry = gtk_entry_new_with_max_length (50);
  if (*fast_name == NULL)
    gtk_entry_set_text (GTK_ENTRY (name_entry), "");
  else
    gtk_entry_set_text (GTK_ENTRY (name_entry), *fast_name);

  /* get the GtkEntry to bind a "changed" signal to figure out when the
     user changed the entry */
  gtk_entry_select_region (GTK_ENTRY (name_entry), 0,
			   GTK_ENTRY (name_entry)->text_length);
  box = gtk_vbox_new (TRUE, 0);

  gtk_container_add (GTK_CONTAINER (frame), box);
  gtk_widget_show (box);
  gtk_box_pack_start (GTK_BOX (box), name_entry, TRUE, TRUE, 0);
  gtk_widget_show (name_entry);
  gtk_widget_grab_focus (name_entry);
  gnome_dialog_set_default (GNOME_DIALOG (name_window), GNOME_OK);
  gnome_dialog_editable_enters (GNOME_DIALOG (name_window),
				GTK_EDITABLE (name_entry));
  while (!name_ok)
    {
      button = gnome_dialog_run (GNOME_DIALOG (name_window));

      /* Cancel or close the window */
      if (button == 1)
	{
	  /* close the window */
	  gnome_dialog_close (GNOME_DIALOG (name_window));
	  name_ok = TRUE;
	  ret = 0;
	}
      else if (button == -1)
	{
	  name_ok = TRUE;
	  ret = 0;
	}
      else if (button == 0)
	{
	  gchar *temp;

	  /* Get the name of the CD */
	  temp = gtk_entry_get_text (GTK_ENTRY (name_entry));
	  if (!compare ("^[ \t]*$", temp, COMPARE_REGEX, FALSE))
	    {
	      if (!warning)
		{
		  warning =
		    gtk_label_new (_("Disk name should not be blank"));
		  gtk_box_pack_start (GTK_BOX (box), warning, TRUE, TRUE, 0);
		  gtk_widget_show (warning);
		}
	      else
		{
		  gtk_label_set_text (GTK_LABEL (warning),
				      _("Disk name should not be blank"));
		}
	    }
	  else if (is_disk_name_unique (racine, temp))
	    {
	      name_ok = TRUE;

	      /* Replace the last name */
	      g_free (*fast_name);
	      *fast_name = g_strdup (temp);

	      gnome_dialog_close (GNOME_DIALOG (name_window));
	      ret = 1;
	    }
	  else
	    {
	      if (!warning)
		{
		  warning = gtk_label_new (_("Disk name already exists"));
		  gtk_box_pack_start (GTK_BOX (box), warning, TRUE, TRUE, 0);
		  gtk_widget_show (warning);
		}
	      else
		{
		  gtk_label_set_text (GTK_LABEL (warning),
				      _("Disk name already exists"));
		}
	    }
	}
      else
	{
	  ret = -1;
	  name_ok = TRUE;
	}
    }

  return (ret);
}

void
fast_add_disk (FOLDER * racine)
{
  gint name_window_status;

  reset_added_disk ();
  /* Fetch the content of the drive meanwhile */
  do_not_forget_to_mount (TRUE);
#ifdef OS_PPC_DARWIN
  if (my_config->read_cd_name)
#else
  if ((my_config->mount_device) && (my_config->read_cd_name))
#endif
    {
      gchar *tmp;
#ifdef OS_PPC_DARWIN
      tmp = get_disk_label (NULL);
#else
      tmp = get_disk_label (my_config->mount_device->str);
#endif
      if (tmp)
	{
	  if (my_config->fast_name)
	    {
	      g_free (my_config->fast_name);
	    }
	  my_config->fast_name = tmp;
	}
      else
	{
	  my_config->fast_name = g_strdup ("");
	}
    }
#ifdef OS_PPC_DARWIN
  set_local_folder_name (mosx_get_cd_mount_point (TRUE));
#else
  set_local_folder_name (my_config->mount_point->str);
#endif

  set_thread_status_to_running ();
  init_vfs_scan_status ();
  set_added_disk (ADDED_DISK_UNDEF);
#if defined(USE_PTHREADS)
  if (pthread_create (&thread1, NULL, start_thread_scan, racine) < 0)
    {
      reinit_thread_status ();
      ERROR_DIALOG (_("Thread failed.\nCheck your number of threads."),
		    main_window);
    }
  else
    {
/* Initialize the status bar */
      /* Create window to enter the name */
      name_window_status =
	fad_create_window (&(my_config->fast_name), racine);

      if (name_window_status == 1)
	{
	  set_local_disk_name (my_config->fast_name);
	  set_added_disk (ADDED_DISK_OK);
	  fad_wait_window ();
	}
      else
	{
	  set_added_disk (ADDED_DISK_DELETE);
	}
      my_timeout (racine);
    }
#else
/* Initialize the status bar */
  /* Create window to enter the name */
  name_window_status = fad_create_window (&(my_config->fast_name), racine);

  if (name_window_status == 1)
    {
      set_local_disk_name (my_config->fast_name);
      set_added_disk (ADDED_DISK_OK);
      fad_wait_window ();
    }
  else
    {
      set_added_disk (ADDED_DISK_DELETE);
    }
  my_timeout (racine);
  start_thread_scan (racine);
#endif
}

int
start_add_cd_for_update (char *foldername, char *diskname, FOLDER * racine)
{
  set_added_disk (ADDED_DISK_UNDEF);
  set_local_disk_name (diskname);
  set_local_folder_name (foldername);

  do_not_forget_to_mount (FALSE);
  set_thread_status_to_running ();
  progress_createTimeout (GINT_TO_POINTER (GNOMEAPPBAR_MAIN));
  do_not_forget_to_umount (TRUE);
  init_vfs_scan_status ();
#if defined(USE_PTHREADS)
  if (pthread_create (&thread1, NULL, start_thread_scan, racine) < 0)
    {
      reinit_thread_status ();
      ERROR_DIALOG (_("Thread failed.\nCheck your number of threads."),
		    main_window);
    }
  else
    {
      my_timeout (racine);
      fad_wait_window ();
      set_added_disk (ADDED_DISK_OK);
    }
#else
  my_timeout (racine);
  fad_wait_window ();
  set_added_disk (ADDED_DISK_OK);
  start_thread_scan (racine);
#endif
  return (0);

}
