/*
 */
#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include <AppKit/NSDocumentController.h>

#include "PreferencePanel.h"
#include "MemoryPanel.h"

#include "GSDictDocument.h"
#include "GSDictParameters.h"
#include "GSDictService.h"

@implementation GSDictService

-(id)init
{
	[super init];
	_databases = nil;
	_strategies = nil;
	_fullData = nil;
	_task = nil;
  return self;  
}

-(void)dealloc
{
	NSLog( @"GSDictService dealloc" );
	TEST_RELEASE( _databases );
	TEST_RELEASE( _strategies );
  if (_task && [_task isRunning]) {
    [_task terminate];
  }
  TEST_RELEASE (_task);
	_task = nil;
  TEST_RELEASE (_fullData);
	_fullData = nil;
	[super dealloc];
}

- (void)dictDefinition:(NSPasteboard*)pb
              userData:(NSString*)ud
                 error:(NSString**)err
{
  NSString	*word = nil;
  NSArray	*types = nil;
  NSString* fileName = nil;
  NSData* data = nil;
  id docController = nil;
  NSDocument* newDoc = nil;
  GSDictParameters* dictParams = nil;

  NSLog( @"GSDict service called" );
  types = [pb types];
  if (![types containsObject: NSStringPboardType])
  {
    *err = @"No string type supplied on pasteboard";
    return;
  }

  word = [pb stringForType: NSStringPboardType];
  if (word == nil)
  {
    *err = @"No string value supplied on pasteboard";
    return;
  }

  dictParams = [GSDictParameters defaultParameters];
  NSAssert( (dictParams!=nil), @"No GSDictParameters found!" );

  [dictParams setWord:word];

  data = [self queryDictWithParameters:dictParams];

  NSAssert( data, @"no data retrieved from query" );

  fileName = [NSString stringWithFormat:@"/tmp/%@.rtf", word ];

  [data writeToFile:fileName atomically:NO];

  NSLog( @"opening new window document" );
  docController = [NSDocumentController sharedDocumentController];
  NSAssert( (docController!=nil), @"No NSDocumentController found!" );
  [[NSApplication sharedApplication] activateIgnoringOtherApps:YES];
  newDoc = [docController openDocumentWithContentsOfFile:fileName display:YES];
  NSAssert( (newDoc!=nil), @"No Document created" );
//  [NSApp setDelegate:docController];
  [[docController currentDocument] addDictParametersToHistory:dictParams];
  [[NSNotificationCenter defaultCenter] postNotificationName:GSDictDidChangeDictParametersHistoryNotification
					              object:nil];
}

- (NSData*)queryDictWithParameters:(GSDictParameters*)parameters
{
	NSDate* delay = nil;
  NSArray	*args = nil;
  NSString	*path = nil;
	NSPipe *newPipe = nil;
	NSFileHandle *readHandle = nil;
	NSString *result = nil;
	NSString* word = nil;
	NSString* database = nil;
	NSString* strategy = nil;
	NSMutableString* dictCmd = nil;

	NSAssert( parameters, @"NO parameters provided" );
	word = [parameters word];
	NSAssert( parameters, @"NO word provided" );
	database = [parameters database];
	NSAssert( database, @"NO database provided" );
	strategy = [parameters strategy];
	NSAssert( strategy, @"NO strategy provided" );
  path = @"/bin/sh";
	dictCmd = [NSMutableString stringWithCString:"dict "];
	if ( [database isEqualToString:@"All"] == NO )
	{
	 	[dictCmd appendFormat:@" -d %@ ", database];
	}
 	[dictCmd appendFormat:@" -s %@ ", strategy];
 	[dictCmd appendString:word];
	if ( [parameters match] == YES )
	{
		NSLog( @"mode match" );
		[dictCmd appendString:@" -m"];
	}
 	args = [NSArray arrayWithObjects: @"-c", dictCmd,	nil];

  TEST_RELEASE(_fullData);
	_fullData = nil;
	
  ASSIGN (newPipe, [NSPipe pipe]);
	readHandle = [newPipe fileHandleForReading];
  ASSIGN (_task, AUTORELEASE ([NSTask new])); 
	[_task setStandardOutput:newPipe];
	[_task setLaunchPath:path];
	[_task setArguments:args];

  [[NSNotificationCenter defaultCenter] addObserver: self
                                        selector:@selector(dataFromTask:)
                                        name:NSFileHandleReadToEndOfFileCompletionNotification
                                        object: (id)readHandle];

	[readHandle readToEndOfFileInBackgroundAndNotify];    
  [[NSNotificationCenter defaultCenter] addObserver: self 
                   selector: @selector(endOfTask:) 
                       name: NSTaskDidTerminateNotification 
                     object: (id)_task];

	[_task launch];

	delay = [NSDate dateWithTimeIntervalSinceNow:10.];
	NSAssert( delay, @"delay" );
	while ( [[NSDate date] compare:delay] == NSOrderedAscending )
	{
		[[NSRunLoop currentRunLoop] runUntilDate: [NSDate dateWithTimeIntervalSinceNow: 0.2]];
		if ( [_task isRunning] == NO )
			break;
	}
	if ( [_task isRunning] == YES )
	{
		NSLog( @"Interrupting task" );
		[_task terminate];
	}
	[_task terminate];

	NSAssert( [readHandle availableData], @"data" );

	NSAssert( _fullData, @"_fullData" );
	[self postProcessData:_fullData toString:&result];
	return [result dataUsingEncoding:NSISOLatin1StringEncoding];
}

- (void)dataFromTask:(NSNotification *)notification
{
  NSDictionary *userInfo;
  NSData *readData;
  NSString* buff;

  userInfo = [notification userInfo];
  readData = [userInfo objectForKey: NSFileHandleNotificationDataItem];

  buff = [[NSString alloc] initWithData: readData encoding: NSNonLossyASCIIStringEncoding];
  AUTORELEASE (buff);
	if ( _fullData == nil)
	{
		ASSIGN(_fullData, [[NSMutableData alloc] init]);
	}
	[_fullData appendData:readData];
}

- (void)endOfTask:(NSNotification *)notification
{
	NSDebugLLog( @"GSDict", @"Task has terminated" );
	{
		int rc = [[notification object] terminationStatus];
    if (rc == 127)
		{
			[NSException raise:GSDictException format:DictCommandNotAvailable];
    }
    if (rc == -1)
		{
			[NSException raise:GSDictException format:DictCommandNotAvailable];
    }
	}
	_task = nil;
}

- (void)postProcessData:(NSData*)data toString:(NSString**)result
{
	NSString* dummy = nil;
	NSCharacterSet *leftbracketSet = nil;
	NSCharacterSet *rightbracketSet = nil;
	NSCharacterSet *returnSet = nil;
	NSScanner *theScanner = nil;
	NSString *word = nil;
	NSString *rawString = nil;
	NSMutableString *output = nil;
	NSMutableString *output2 = nil;
	NSArray* components = nil;
	int i = 0;

	unsigned i1 = 0, i2 = 0;
	unsigned previousScanLocation = 0;
	leftbracketSet = [NSCharacterSet characterSetWithCharactersInString:@"{"];
	rightbracketSet = [NSCharacterSet characterSetWithCharactersInString:@"}"];
	returnSet = [NSCharacterSet characterSetWithCharactersInString:@"\n"];

	rawString = [[NSMutableString alloc] initWithData:data
													encoding:NSNonLossyASCIIStringEncoding];

//	rawString = [[NSMutableString alloc] initWithContentsOfFile:@"/tmp/test.txt"];
	theScanner = [NSScanner scannerWithString:rawString];
	output = [[NSMutableString alloc] init];
	while ([theScanner isAtEnd] == NO)
	{
		if ([theScanner scanUpToCharactersFromSet:leftbracketSet intoString:&dummy])
		{
			[output appendString:dummy];
			if ([theScanner scanUpToCharactersFromSet:rightbracketSet intoString:&word])
			{
				NSRange toExtract = NSMakeRange( 1, [word length]-1 );
				[output appendString:@"\{\\fs24\\b "];
				[output appendString:[word substringFromRange:toExtract]];
				[output appendString:@" }"];
				[theScanner setScanLocation:[theScanner scanLocation]+1];
			}
			else
			{
				break;
			}
		}
		else
		{
			if ([theScanner scanUpToCharactersFromSet:rightbracketSet intoString:&word])
			{
				NSRange toExtract = NSMakeRange( 1, [word length]-1 );
				[output appendString:@"\{\\fs24\\b "];
				[output appendString:[word substringFromRange:toExtract]];
				[output appendString:@" }"];
				[theScanner setScanLocation:[theScanner scanLocation]+1];
			}
			else
			{
				break;
			}
		}
	}

	NS_DURING
	{
		output2 = [[NSMutableString alloc] initWithString:@"\{\\rtf1\\ansi\{\\fonttbl\\f0\\fswiss Helvetica;}\n"];
		components = [output componentsSeparatedByString:@"\n"];
		for ( i = 0; i < [components count]; i++ )
		{
			[output2 appendString:@"\\pard\\plain\\f0\\fs24 "];
			[output2 appendString:[components objectAtIndex:i]];
			[output2 appendString:@"\\par\n"];
		}
	
		[output2 appendString:@"}"];
		*result = output2;
	}
  NS_HANDLER
	{
		NSLog( @"exception catched=%@, %@", [localException name], [localException reason] );
	}
	NS_ENDHANDLER
	[rawString release];
}

- (NSArray*)dictInfosWithArgs:(NSString*)cmdArgs
{
  NSArray	*args;
  NSArray	*lines;
  NSString	*path;
  NSTask	*task;
	NSPipe *newPipe;
	NSFileHandle *readHandle;
	NSData *segmentData;
	NSMutableData *fullData;
	NSString *result;
	int i;
	id resultArray = nil;

	path = @"/bin/sh";
  args = [NSArray arrayWithObjects: @"-c", cmdArgs, nil];

	NSLog( @"args=%@", [args description] );
	newPipe = [NSPipe pipe];
	readHandle = [newPipe fileHandleForReading];
	task = [[NSTask alloc] init];
	[task setStandardOutput:newPipe];
	[task setLaunchPath:path];
	[task setArguments:args];
	[task launch];

	[task waitUntilExit];
	{
		int rc = [task terminationStatus];
    if (rc != 0)
		{
			NSLog( @"dict command not available" );
			[NSException raise:GSDictException format:DictCommandNotAvailable];
    }
	}

	segmentData = nil;
	fullData = [NSMutableData dataWithCapacity:100];
	while ((segmentData = [readHandle availableData]) && [segmentData length])
	{
		[fullData appendData:segmentData];
	}
  result = [[[NSString alloc] initWithData:fullData
													encoding:NSISOLatin1StringEncoding] autorelease];
	lines = [result componentsSeparatedByString:@"\n"];
	resultArray = [[NSMutableArray alloc] initWithCapacity:[lines count]-1];
	for ( i = 1; i < [lines count]-1; i++ )
	{
		NSRange aRange = { 0, 13 };
		NSString* tmp = [[lines objectAtIndex:i] substringWithRange:aRange];
		NSMutableString *item =[NSMutableString stringWithString:tmp];
		[item replaceString:@" " withString:@""];
		[resultArray addObject:item];
	}
	return resultArray;
}

- (NSArray*)databases
{
	if ( _databases != nil )
		return _databases;
	_databases = [self dictInfosWithArgs:@"dict -D"];
	[(NSMutableArray*)_databases insertObject:@"All" atIndex:0];
	NSAssert( _databases, @"_databases not initialized" );
	return _databases;
}

- (NSArray*)strategies
{
	if ( _strategies != nil )
		return _strategies;
	_strategies = [self dictInfosWithArgs:@"dict -S"];
	NSAssert( _strategies, @"_strategies not initialized" );
	return _strategies;
}

@end

@interface GSDict : NSObject
{
}

- (void) applicationWillFinishLaunching: (NSNotification *)not;
- (void) applicationDidFinishLaunching: (NSNotification *)not;
- (void) orderFrontPreferencesPanel:(id)sender;

@end

@implementation GSDict : NSObject 

- (void) applicationWillFinishLaunching: (NSNotification *)not
{
  CREATE_AUTORELEASE_POOL(pool);
  NSMenu *menu;
  NSMenu *info;
  NSMenu *file;
  NSMenu *edit;
  NSMenu *print;
  NSMenu *services;
  NSMenu *windows;
// 	NSMenuItem* menuItem;

  //	Create the app menu
  menu = [NSMenu new];
  [[NSApplication sharedApplication] setMainMenu: menu];

  [menu addItemWithTitle: @"Info"
		  action: NULL
	   keyEquivalent: @""];

  [menu addItemWithTitle: @"File"
		  action: NULL
	   keyEquivalent: @""];

  [menu addItemWithTitle: @"Edit"
		  action: NULL
	   keyEquivalent: @""];

  [menu addItemWithTitle: @"Windows"
		  action: NULL
	   keyEquivalent: @""];

  [menu addItemWithTitle: @"Print"
		  action: NULL
	   keyEquivalent: @"p"];

  [menu addItemWithTitle: @"Services"
		  action: NULL
	   keyEquivalent: @""];

  [menu addItemWithTitle: @"Hide"
		  action: @selector(hide:)
	   keyEquivalent: @"h"];

  [menu addItemWithTitle: @"Quit"
		  action: @selector(terminate:)
	   keyEquivalent: @"q"];

  // Create the info submenu
  info = [NSMenu new];
  [menu setSubmenu: info
	   forItem: [menu itemWithTitle: @"Info"]];

  [info addItemWithTitle: @"Info Panel..."
	          action: @selector(orderFrontStandardInfoPanel:)
	   keyEquivalent: @""];

//   menuItem = [info addItemWithTitle: @"Preferences..."
// 			          action: @selector(orderFrontPreferencesPanel:)
// 								keyEquivalent: @""];
// 	[menuItem setTarget:self];
  [info addPreferencePanelSubmenu];
  [info addMemoryPanelSubmenu];

/*  
  [info addItemWithTitle: @"Preferences..."
		  action: NULL
	   keyEquivalent: @""];
*/
  [info addItemWithTitle: @"Help"
		  action: @selector (orderFrontHelpPanel:)
	   keyEquivalent: @"?"];
  RELEASE(info);

  // Create the file submenu
  file = [NSMenu new];
  [menu setSubmenu: file
	   forItem: [menu itemWithTitle: @"File"]];

  [file addItemWithTitle: @"New Definition"
		  action: @selector(newDocument:)
	   keyEquivalent: @"n"];

  RELEASE(file);

  // Create the edit submenu
  edit = [NSMenu new];
  [menu setSubmenu: edit
	   forItem: [menu itemWithTitle: @"Edit"]];

  [edit addItemWithTitle: @"Copy"
	          action: @selector(copy:)
	   keyEquivalent: @"c"];

  [edit addItemWithTitle: @"Select All"
  	          action: @selector(selectAll:)
	   keyEquivalent: @"a"];
  RELEASE(edit);

  // Create the printing submenu
  print = [NSMenu new];
  [menu setSubmenu: print
	   forItem: [menu itemWithTitle: @"Print"]];
  [print addItemWithTitle: @"Print"
		  action: @selector(printDocument:)
	   keyEquivalent: @"p"];

  [print addItemWithTitle: @"Setup Printer"
		  action: @selector(runPageLayout:)
	   keyEquivalent: @"P"];

  RELEASE(print);

  // Create the windows submenu
  windows = [NSMenu new];
  [menu setSubmenu: windows
	   forItem: [menu itemWithTitle: @"Windows"]];

  [windows addItemWithTitle: @"Arrange"
		     action: @selector(arrangeInFront:)
	      keyEquivalent: @""];

  [windows addItemWithTitle: @"Miniaturize"
		     action: @selector(performMiniaturize:)
	      keyEquivalent: @"m"];

  [windows addItemWithTitle: @"Close"
		     action: @selector(performClose:)
	      keyEquivalent: @"w"];

  [[NSApplication sharedApplication] setWindowsMenu: windows];
  RELEASE(windows);

  // Create the service submenu
  services = [NSMenu new];
  [menu setSubmenu: services
	   forItem: [menu itemWithTitle: @"Services"]];

  [[NSApplication sharedApplication] setServicesMenu: services];
  RELEASE(services);

	[menu update];
	[menu display];
  RELEASE(menu);

  RELEASE(pool);
}

- (void) applicationDidFinishLaunching: (NSNotification *)not
{
	GSDict *dictServices = nil;

  // Make the GSDictDocumentController the delegate of the application , as this is the only way 
  // I know to bring it into the responder chain
  [[NSApplication sharedApplication] setDelegate: [NSDocumentController sharedDocumentController]];
	dictServices = [[GSDictService alloc] init];
	[NSApp setServicesProvider:dictServices];
}

- (void) orderFrontPreferencesPanel:(id)sender
{
	NSLog( @"message recu" );
}

@end

int
main(int argc, const char **argv, char** env)
{
  id theApp = nil;
	id pool = [NSAutoreleasePool new];
#if LIB_FOUNDATION_LIBRARY
	[NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif
#ifndef NX_CURRENT_COMPILER_RELEASE
	initialize_gnustep_backend();
#endif
	theApp = [NSApplication sharedApplication];
  [theApp setDelegate:[[GSDict alloc] init]];

	[theApp run];
	[pool release];
	return 0;
}
