#ifndef GSDictDocument_h
#define GSDictDocument_h

#include <Foundation/NSData.h>
#include <Foundation/NSAttributedString.h>
#include <AppKit/NSDocument.h>
#include <AppKit/NSTextView.h>
#include <AppKit/NSPrintInfo.h>

@class GSDictParameters;

extern NSString *GSDictDidChangeDictParametersHistoryNotification;
extern NSString *GSDictException;
extern NSString *DictCommandNotAvailable;

@interface GSDictDocument : NSDocument
{
	NSMutableAttributedString *ts;
	NSTextView *tv;
	NSPopUpButton *_databasePopup;
	NSPrintInfo *pi;
	NSString* _lastWord;
	NSComboBox *_lastWords;
	NSString* _lastDatabase;
	NSButton* _back;
	NSButton* _forward;
	NSMutableArray* _navigationHistory;
	int _navigationPos:30;
	int _logNavigation:2;
}

- (void)addDictParametersToHistory:(GSDictParameters*)dictParams;

- (void)updateDefinitionWithParameters:(GSDictParameters*)dictParams;

@end

#endif
