#include "segment.h"


/*!
 * \brief flush pending updates to disk
 *
 * Forces all pending updates generated by <i>segment_put</i> to be written to the
 * segment file <b>seg.</b> Must be called after the final segment_put() to
 * force all pending updates to disk. Must also be called before the first call
 * to <i>segment_get_row.</i>
 *
 *  \param seg
 *  \return int
 */

int segment_flush (SEGMENT *SEG)
{
    int i;

    for (i = 0; i < SEG->nseg; i++)
	if (SEG->scb[i].n >= 0 && SEG->scb[i].dirty)
	    segment_pageout (SEG, i);

	return 0;
}
