#include "config.h"

#include <stdlib.h>

#include <iostream>
#include <string>

#include "gql++/driver-manager.h"
#include "gql++/exception.h"
#include "gql++/result-set.h"
#include "gql++/statement.h"
#include "gql++/database-metadata.h"

using namespace GQL;
using namespace uC;
using namespace std;

static void usage();

int main(int argc, char *argv[])
{
  DriverManager man;
  string url, user, passwd;
  
  if (argc < 2 || argc > 4)
  {
    usage();
    exit(EXIT_FAILURE);
  }

  url = argv[1];
  
  if (argc > 2)
    user = argv[2];
  if (argc > 3)
    passwd = argv[3];
  
  try
  {
    Connection *conn = man.get_connection(url, user, passwd);
    DatabaseMetaData *dbmd;
    string s;
    SQLObject *str_obj = conn->create_object();
    ResultSet *rs;
    vector<string> types(1);
    
    dbmd = conn->get_meta_data();
    types[0] = "TABLE";
    rs = dbmd->get_tables("", "", "", types);

    while (rs->next())
    {
      rs->get(2, str_obj);
      cout << str_obj->to_string() << endl;
    }

    delete conn;

    cout << endl;

    const PluginNode& drivers = man.get_drivers();
    for (PluginNode::iterator it = drivers.begin();
         it != drivers.end(); ++it)
      cout << (*it).name() << " - " << (*it).plugin() << endl;
  }

  catch (SQLException& e)
  {
    cout << "SQLException: " << e.what() << endl;
    return(EXIT_FAILURE);
  }
}

static void usage()
{
  cout << "usage: simple <database> [<user> [<pwd>]]" << endl;
}
