#include "result-set.h"
#include "result-set-metadata.h"

#include <strstream>

namespace GQL
{

namespace PG
{

PGResultSet::~PGResultSet()
{
  if (result_)
    PQclear(result_);
}

bool PGResultSet::next() throw(SQLException)
{
  if (result_ && PQntuples(result_) > rowno_ + 1)
  {
    rowno_++;
    return(true);
  }
  return(false);
}

void PGResultSet::get(int i, SQLObject *obj) const throw(SQLException)
{
  if (!result_)
    throw SQLException("ResultSet does not contain any data");

  if (i < 0 || i >= PQnfields(result_))
    throw SQLException("Attempt to access invalid field");

  if (PQgetisnull(result_, rowno_, i))
    obj->set_null();

  obj->from_string(PQgetvalue(result_, rowno_, i));
}

ResultSetMetaData *PGResultSet::get_meta_data()
{
  return(new PGResultSetMetaData(get_connection(), result_));
}

}

}
