/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_STATEMENT_H)
#define __INC_STATEMENT_H

#include "gql++/warnable.h"
#include "gql++/connection.h"

namespace GQL
{

class ResultSet;

class Statement : public Warnable
{
  public:
    Statement(Connection *conn) : conn_(conn) { }
    virtual ~Statement() { }

    virtual bool execute(const string& sql) = 0;

    virtual ResultSet *execute_query(const string& sql) = 0;
    virtual int execute_update(const string& sql) = 0;

    Connection *get_connection() { return(conn_); }
    const Connection *get_connection() const { return(conn_); }
    
    virtual ResultSet *get_result_set() = 0;
    virtual bool get_more_results() = 0;
    
    virtual int get_fetch_size() const = 0;
    virtual void set_fetch_size(int size) = 0;

    virtual int get_max_field_size() const = 0;
    virtual void set_max_field_size(int size) = 0;
    
    virtual int get_max_rows() const = 0;
    virtual void set_max_rows(int num) = 0;
  private:
    Connection *conn_;
};


}

#endif
