struct Pref_Dialog
{
  GtkWidget *prefdialog;
  GtkWidget *prefnotebook;

  GtkWidget *generalpage;
  GtkWidget *generaltab;
  GtkWidget *autobright;

  GtkWidget *filterspage;
  GtkWidget *filterstab;
  GtkWidget *rgbswap;

  GtkWidget *button;
  GtkWidget *label;
};

struct Page_Ppm
{
  GtkWidget *frame_ppm;
  GtkWidget *label_ppm;
  GtkWidget *radio_raw_ppm;
  GtkWidget *radio_ascii_ppm;
  GtkWidget *vbox_ppm;
  GSList *group_ppm;
};

struct Page_Jpeg 
{
  GtkWidget *frame_jpeg;
  GtkWidget *vbox_jpeg;
  GtkWidget *table_jpeg;
  GtkWidget *quality_jpeg;
  GtkWidget *smooth_jpeg;
  GtkWidget *label_jpeg;
  GtkWidget *optimize_jpeg;
  GtkObject *quality_adj_jpeg;
  GtkObject *smooth_adj_jpeg;
};

struct Page_Png
{
  GtkWidget *frame_png;
  GtkWidget *vbox_png;
  GtkWidget *hbox_png;
  GtkWidget *interlace_png;
  GtkWidget *label_png;
  GtkWidget *compression_png;
  GtkObject *compression_adj_png;  
};

struct Page_Gif
{
  GtkWidget *frame_gif;
  GtkWidget *vbox_gif;
  GtkWidget *label_gif;
  GtkWidget *interlace_gif;
  GtkWidget *comment_gif;
  GtkWidget *comment_text_gif;
  GtkWidget *scrollbox_gif;
};

struct Save_Struct
{
  struct Page_Ppm page_ppm;
  struct Page_Jpeg page_jpeg;
  struct Page_Gif page_gif;
  struct Page_Png page_png;
  int isinfo;
  int quality;
  int smoothness;
  int optimize;
  int format;
  png_byte interlace;
  int compression;
  GtkWidget *textbox;
  GtkWidget *fileselect;
  GtkWidget *timebutton;
};

struct Timer_Struct
{
  int time;
  int unit;
  int beep;
  int iscommand;
  char command[255];

  GtkWidget *timerdialog;
  GtkWidget *hbox;
  GtkWidget *spinlabel;
  GtkWidget *spinbutton;
  GtkObject *spinadjust;
  GtkWidget *dropbox;
  GtkWidget *dropboxmenu;
  GtkWidget *secondsitem;
  GtkWidget *minutesitem;
  GtkWidget *beepselect;
  GtkWidget *commandlabel;
  GtkWidget *commandentry;
  GtkWidget *imageinfobutton;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
};

enum Unit_Types {
  SECONDS = 0,
  MINUTES = 1
};

struct Controls
{
  GtkWidget *outerbox;
  GtkWidget *innerbox;
  GtkWidget *scalebox;
  GtkWidget *sizedepthbox;
  GtkWidget *frame;
  GtkObject *adjbrightness;
  GtkWidget *scalebrightness;
  GtkObject *adjwhite;
  GtkWidget *scalewhite;
  GtkObject *adjcontrast;
  GtkWidget *scalecontrast;
  GtkObject *adjhue;
  GtkWidget *scalehue;
  GtkObject *adjcolor;
  GtkWidget *scalecolor;
  GtkWidget *radiobutton;
  GSList *radiogroup;
  GtkWidget *button;
};


struct Camera
{
  int dev;
  int greyscale;
  int draw;
  int frozen;
  int update_camera;
  int capture;
  int saving;
  int savetype;
  int docked;
  int dump;
  int speed_fastest;
  int on_timer;
  int timeout;
  int swapcolors;
  int autobright;
  guint timeoutid;
  struct video_capability vid_caps;
  struct video_window vid_win;
  struct video_picture vid_pic;
  struct video_clip vid_clips[32];
  unsigned char *pic;
  unsigned char *picbuff;
  char devname[256];
  char savefile[256];
  char savefileclean[256];
  GtkWidget *drawing_area;
  GtkWidget *controlcontainer, *controltop, *controlwindow;
  GtkWidget *statusbar;
  GtkWidget *currentsavepage;
  pthread_mutex_t iscam_mutex, pref_mutex, freeze_mutex;
  GdkPixmap *pixmap;
  int fps_avg;
  int fps_current;
  struct Page_Ppm page_ppm;
  struct Page_Jpeg page_jpeg;
  struct Page_Gif page_gif;
  struct Page_Png page_png;
  struct Save_Struct save_struct;
  struct Timer_Struct timer_struct;
  struct Controls controls;
  struct Pref_Dialog pref_dialog;
};



void display(struct Camera*);
void delete_event(GtkWidget*, struct Camera *camera);
void open_cam(struct Camera*);
void close_cam(struct Camera*, int force);
void print_cam_info(struct Camera*);
void get_cam_info(struct Camera*);
void dump_locks( struct Camera *camera );
int dump_pict( struct Camera *camera, char *tofile, int brightness, int contrast, int whiteness );
void print_usage();
int next_frame( struct Camera *camera );
