#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <pthread.h>
#include <linux/types.h> 
#include <gtk/gtk.h>
#include <linux/videodev.h>
#include <png.h>
#include "gqcam.h"
#include "frontend.h"
#include "color.h"



void create_controls_color(struct Camera *camera)
{
/*
  GtkWidget *outerbox;
  GtkWidget *innerbox;
  GtkWidget *scalebox;
  GtkWidget *sizedepthbox;
  GtkWidget *frame;
  GtkObject *adjbrightness;
  GtkWidget *scalebrightness;
  GtkObject *adjwhite;
  GtkWidget *scalewhite;
  GtkObject *adjcontrast;
  GtkWidget *scalecontrast;
  GtkObject *adjhue;
  GtkWidget *scalehue;
  GtkObject *adjcolor;
  GtkWidget *scalecolor;
  GtkWidget *radiobutton;
  GSList *camera->controls.radiogroup;
  GtkWidget *button;
*/
  int ib=130, ic=30, iw=150, i, count=32;
  gint context_id;

  /* Create new outerbox */
  camera->controltop = gtk_hbox_new (FALSE, 0);

  /* Create scalebox */
  camera->controls.scalebox = gtk_vbox_new (FALSE, 2);
  gtk_widget_set_usize (GTK_WIDGET(camera->controls.scalebox), 240, 250);
  gtk_box_pack_start( GTK_BOX (camera->controltop), camera->controls.scalebox, 1, 1, 0);
  gtk_widget_show (camera->controls.scalebox);

  /* Create Brightness Scale */
  camera->controls.frame = gtk_frame_new("Brightness");
  gtk_box_pack_start( GTK_BOX (camera->controls.scalebox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);

  camera->controls.adjbrightness = gtk_adjustment_new(camera->vid_pic.brightness/256, 0, 255, 1, 10, 1);
  camera->controls.scalebrightness = gtk_hscale_new(GTK_ADJUSTMENT(camera->controls.adjbrightness));
  gtk_range_set_update_policy( GTK_RANGE(camera->controls.scalebrightness), GTK_UPDATE_DELAYED ); 

  gtk_signal_connect (GTK_OBJECT (camera->controls.adjbrightness), "value_changed", GTK_SIGNAL_FUNC (setbrightness), camera);

  gtk_scale_set_digits(GTK_SCALE(camera->controls.scalebrightness), 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.scalebrightness);
  gtk_widget_show (camera->controls.scalebrightness);
  
  /* Create White Balance Scale */
  camera->controls.frame = gtk_frame_new("White Balance");
  gtk_box_pack_start( GTK_BOX (camera->controls.scalebox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);
  camera->controls.adjwhite = gtk_adjustment_new(camera->vid_pic.whiteness/256, 0, 255, 1, 10, 1);
  camera->controls.scalewhite = gtk_hscale_new(GTK_ADJUSTMENT(camera->controls.adjwhite));
  gtk_range_set_update_policy( GTK_RANGE(camera->controls.scalewhite), GTK_UPDATE_DELAYED ); 

  gtk_signal_connect (GTK_OBJECT (camera->controls.adjwhite), "value_changed", GTK_SIGNAL_FUNC (setwhite), camera);

  gtk_scale_set_digits(GTK_SCALE(camera->controls.scalewhite), 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.scalewhite);
  gtk_widget_show (camera->controls.scalewhite);

  /* Create Contrast Scale */
  camera->controls.frame = gtk_frame_new("Contrast");
  gtk_box_pack_start( GTK_BOX (camera->controls.scalebox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);

  camera->controls.adjcontrast = gtk_adjustment_new(camera->vid_pic.contrast/256, 0, 255, 1, 10, 1);
  camera->controls.scalecontrast = gtk_hscale_new(GTK_ADJUSTMENT(camera->controls.adjcontrast));
  gtk_range_set_update_policy( GTK_RANGE(camera->controls.scalecontrast), GTK_UPDATE_DELAYED ); 


  gtk_signal_connect (GTK_OBJECT (camera->controls.adjcontrast), "value_changed", GTK_SIGNAL_FUNC (setcontrast), camera);

  gtk_scale_set_digits(GTK_SCALE(camera->controls.scalecontrast), 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.scalecontrast);
  gtk_widget_show (camera->controls.scalecontrast);

  /* Create Hue Scale */
  camera->controls.frame = gtk_frame_new("Hue");
  gtk_box_pack_start( GTK_BOX (camera->controls.scalebox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);

  camera->controls.adjhue = gtk_adjustment_new(camera->vid_pic.hue/256, 0, 255, 1, 10, 1);
  camera->controls.scalehue = gtk_hscale_new(GTK_ADJUSTMENT(camera->controls.adjhue));
  gtk_range_set_update_policy( GTK_RANGE(camera->controls.scalehue), GTK_UPDATE_DELAYED ); 

  gtk_signal_connect (GTK_OBJECT (camera->controls.adjhue), "value_changed", GTK_SIGNAL_FUNC (sethue), camera);

  gtk_scale_set_digits(GTK_SCALE(camera->controls.scalehue), 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.scalehue);
  gtk_widget_show (camera->controls.scalehue);

  /* Create Color Scale */
  camera->controls.frame = gtk_frame_new("Color");
  gtk_box_pack_start( GTK_BOX (camera->controls.scalebox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);

  camera->controls.adjcolor = gtk_adjustment_new(camera->vid_pic.colour/256, 0, 255, 1, 10, 1);
  camera->controls.scalecolor = gtk_hscale_new(GTK_ADJUSTMENT(camera->controls.adjcolor));

  gtk_signal_connect (GTK_OBJECT (camera->controls.adjcolor), "value_changed", GTK_SIGNAL_FUNC (setcolor), camera);

  gtk_scale_set_digits(GTK_SCALE(camera->controls.scalecolor), 0);
  gtk_range_set_update_policy( GTK_RANGE(camera->controls.scalecolor), GTK_UPDATE_DELAYED ); 

  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.scalecolor);
  gtk_widget_show (camera->controls.scalecolor);

  /* Create sizedepthbox */
  camera->controls.sizedepthbox = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start( GTK_BOX (camera->controltop), camera->controls.sizedepthbox, 1, 1, 0);
  gtk_widget_show (camera->controls.sizedepthbox);

  /* This is the size... */
  camera->controls.frame = gtk_frame_new("Size");
  gtk_box_pack_start( GTK_BOX (camera->controls.sizedepthbox), camera->controls.frame, 1, 1, 0);
  gtk_widget_show (camera->controls.frame);

  camera->controls.innerbox = gtk_vbox_new (TRUE, 0);
  gtk_container_add (GTK_CONTAINER (camera->controls.frame), camera->controls.innerbox);
  gtk_widget_show (camera->controls.innerbox);

  camera->controls.radiobutton = gtk_radio_button_new_with_label (NULL, "Full");
  gtk_box_pack_start (GTK_BOX (camera->controls.innerbox), camera->controls.radiobutton, TRUE, TRUE, 0);

  if (camera->vid_win.width == camera->vid_caps.maxwidth)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (camera->controls.radiobutton), TRUE);
  gtk_signal_connect(GTK_OBJECT (camera->controls.radiobutton), "pressed", GTK_SIGNAL_FUNC(setsizefull), camera);

  gtk_widget_show (camera->controls.radiobutton);
  
  camera->controls.radiogroup = gtk_radio_button_group (GTK_RADIO_BUTTON (camera->controls.radiobutton));
  camera->controls.radiobutton = gtk_radio_button_new_with_label(camera->controls.radiogroup, "Half");
  gtk_box_pack_start (GTK_BOX (camera->controls.innerbox), camera->controls.radiobutton, TRUE, TRUE, 0);

  if (camera->vid_win.width == (camera->vid_caps.maxwidth)/2)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (camera->controls.radiobutton), TRUE);

  gtk_signal_connect (GTK_OBJECT (camera->controls.radiobutton), "pressed",
		      (GtkSignalFunc) setsizehalf, camera);

  //  gtk_signal_connect(GTK_OBJECT (camera->controls.radiobutton), "clicked", (GtkSignalFunc)setsizehalf, camera);

  gtk_widget_show (camera->controls.radiobutton);

  camera->controls.radiobutton = gtk_radio_button_new_with_label( gtk_radio_button_group (GTK_RADIO_BUTTON (camera->controls.radiobutton)), "Quarter");
  gtk_box_pack_start (GTK_BOX (camera->controls.innerbox), camera->controls.radiobutton, TRUE, TRUE, 0);

  if (camera->vid_win.width == (camera->vid_caps.maxwidth)/4)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (camera->controls.radiobutton), TRUE);
  gtk_signal_connect(GTK_OBJECT (camera->controls.radiobutton), "pressed", (GtkSignalFunc)setsizequarter, camera);

  gtk_widget_show (camera->controls.radiobutton);

  gtk_widget_show (camera->controltop);
  
}
