/* gpsk31  - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 0.2.4 - May 2000
 *
 */

/*
 * call_dialog.c - Functions for the QSO Data Window
 */


#include <gtk/gtk.h>
#include <ctype.h>
#include "main_screen.h"
#include "call_dialog.h"
#include "menu.h"
#include "globals.h"

static int x=-1,y=-1;	/* The Position of the dialog */

struct qsodata qsodata;
struct qso_dialog qso_dialog;

void
call_dialog_key_input (GtkWidget * widget, GdkEventKey * event)	// Will be called when we hit a key
								  // in the Call Dialog
{
  int state;
  gint key;

  state = event->state;
  key = event->keyval;
  if (state & GDK_MOD1_MASK)
    {				// ALT-Key 
      if (key == 'c' || key == 'C')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.call_text));
      if (key == 'n' || key == 'N')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.name_text));
      if (key == 'q' || key == 'Q')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.qth_text));
      if (key == 's' || key == 'S')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.rst_s_text));
      if (key == 'r' || key == 'R')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.rst_r_text));
      if (key == 'o' || key == 'O')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.notes_text));
      if (key == 'f' || key == 'F')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.freq_text));
      if (key == 'h' || key == 'H')
	toggle_call_dialog ();
//              if (key == 'l' || key == 'H' {                  
//                                                              // TODO: Write to Log;
//              }
      if (key == 'e' || key == 'E')
	clear_values ();	// clear the current values from window
    }
  if (key == 65479)
    {				// F10, we hide the window
	toggle_call_dialog ();
    }
}

void
init_call_dialog ()		// This function inits the Dialog
{

  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *label;

  GtkWidget *separator;
  GtkWidget *table;
  GtkWidget *save_button;
  GtkWidget *ok_button;
  GtkWidget *clear_button;

  qso_dialog.window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (qso_dialog.window), "QSO Details");
  vbox = gtk_vbox_new (FALSE, 5);

  table = gtk_table_new (6, 4, FALSE);	/* Create the Table with the text entry */
  gtk_table_set_row_spacings (GTK_TABLE (table), 7);
  gtk_table_set_col_spacings (GTK_TABLE (table), 7);
  gtk_container_add (GTK_CONTAINER (qso_dialog.window), vbox);
  gtk_container_set_border_width (GTK_CONTAINER (qso_dialog.window), 7);

  label = gtk_label_new ("Call:");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  qso_dialog.call_text = gtk_entry_new_with_max_length (25);
  gtk_widget_set_usize (GTK_WIDGET (qso_dialog.call_text), 90, 0);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
			     0, 1, 0, 1);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (qso_dialog.call_text), 1, 3, 0, 1);

  label = gtk_label_new ("Name:");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  qso_dialog.name_text = gtk_entry_new_with_max_length (25);
  gtk_widget_set_usize (GTK_WIDGET (qso_dialog.name_text), 160, 0);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
			     0, 1, 1, 2);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (qso_dialog.name_text), 1, 4, 1, 2);

  label = gtk_label_new ("QTH:");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  qso_dialog.qth_text = gtk_entry_new_with_max_length (25);
  gtk_widget_set_usize (GTK_WIDGET (qso_dialog.qth_text), 160, 0);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET (label),
			     0, 1, 2, 3);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (qso_dialog.qth_text), 1, 4, 2, 3);

  label = gtk_label_new ("RST S:");
  qso_dialog.rst_s_text = gtk_entry_new_with_max_length (6);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_label_set_pattern (GTK_LABEL (label), "    _");
  gtk_widget_set_usize (GTK_WIDGET (qso_dialog.rst_s_text), 50, 0);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (label), 0, 1, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (qso_dialog.rst_s_text), 1, 2, 3, 4);
  label = gtk_label_new ("RST R:");
  gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
  qso_dialog.rst_r_text = gtk_entry_new_with_max_length (6);
  gtk_label_set_pattern (GTK_LABEL (label), "    _");
  gtk_widget_set_usize (GTK_WIDGET (qso_dialog.rst_r_text), 50, 0);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (label), 2, 3, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (qso_dialog.rst_r_text), 3, 4, 3, 4);

  label = gtk_label_new ("Notes:");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  qso_dialog.notes_text = gtk_entry_new_with_max_length (50);
  gtk_label_set_pattern (GTK_LABEL (label), " _");

  gtk_widget_set_usize (GTK_WIDGET (qso_dialog.notes_text), 160, 0);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (label), 0, 1, 4, 5);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (qso_dialog.notes_text), 1, 4, 4, 5);


  label = gtk_label_new ("Freq.:");
  qso_dialog.freq_text = gtk_entry_new_with_max_length (10);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_widget_set_usize (GTK_WIDGET (qso_dialog.freq_text), 50, 0);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (label), 0, 1, 5, 6);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
			     (qso_dialog.freq_text), 1, 2, 5, 6);

  /* Put the table in the vbox */
  gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (table), FALSE, FALSE, 0);


  /* Create a separator, and put it into the box */
  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (separator), FALSE, FALSE,
		      3);


  /* Create the buttons of our dialog */

  label = gtk_label_new ("Hide");
  ok_button = gtk_button_new ();
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_container_add (GTK_CONTAINER (ok_button), label);

  label = gtk_label_new ("Log QSO");
  save_button = gtk_button_new ();
  gtk_label_set_pattern (GTK_LABEL (label), " _");
  gtk_container_add (GTK_CONTAINER (save_button), label);
  gtk_widget_set_sensitive (GTK_WIDGET (save_button), 0);

  label = gtk_label_new ("Clear");
  clear_button = gtk_button_new ();
  gtk_label_set_pattern (GTK_LABEL (label), "  _");
  gtk_container_add (GTK_CONTAINER (clear_button), label);

  /* Generate an hbox for the Buttons, and put them into the box */

  hbox = gtk_hbox_new (TRUE, 5);

  gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (ok_button), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (save_button), TRUE, TRUE,
		      0);
  gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (clear_button), TRUE, TRUE,
		      0);

  /* Pack the hbox into the dialog */

  gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (hbox), FALSE, FALSE, 5);

  /* Acivate the callsign entry */

  gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.call_text));
  gtk_window_set_policy (GTK_WINDOW (qso_dialog.window), 0, 0, 0);

////    And Now the callbacks
/////////////////////////////

  gtk_signal_connect (GTK_OBJECT (qso_dialog.window), "key_press_event",
		      (GtkSignalFunc) call_dialog_key_input, NULL);

  gtk_signal_connect (GTK_OBJECT (qso_dialog.window), "delete_event",
                      GTK_SIGNAL_FUNC (toggle_call_dialog), NULL);

  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      (GtkSignalFunc) (toggle_call_dialog), NULL);

  gtk_signal_connect (GTK_OBJECT (clear_button), "clicked",
		      (GtkSignalFunc) clear_values, NULL);
}

void
clear_values ()			// Clear the values
{
  qsodata.call[0] = '\0';
  qsodata.name[0] = '\0';
  qsodata.qth[0] = '\0';
  qsodata.rst_s[0] = '\0';
  qsodata.rst_r[0] = '\0';
  qsodata.notes[0] = '\0';

  gtk_entry_set_text (GTK_ENTRY (qso_dialog.call_text), qsodata.call);
  gtk_entry_set_text (GTK_ENTRY (qso_dialog.name_text), qsodata.name);
  gtk_entry_set_text (GTK_ENTRY (qso_dialog.qth_text), qsodata.qth);
  gtk_entry_set_text (GTK_ENTRY (qso_dialog.rst_s_text), qsodata.rst_s);
  gtk_entry_set_text (GTK_ENTRY (qso_dialog.rst_r_text), qsodata.rst_r);
  gtk_entry_set_text (GTK_ENTRY (qso_dialog.notes_text), qsodata.notes);

  /* And set the focus to the call entry */

  gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.call_text));

}


void
set_values ()			// Read the dialog, and set the Values
{
  int i;
  strcpy (qsodata.call,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.call_text)));
  // We have the Callsign always in upper case!
  i = 0;
  while (i <= 12)
    {
      qsodata.call[i] = toupper (qsodata.call[i]);
      ++i;
    }
  gtk_entry_set_text (GTK_ENTRY (qso_dialog.call_text), qsodata.call);
  gtk_statusbar_pop (GTK_STATUSBAR (statusbar.call), 1);
  gtk_statusbar_push (GTK_STATUSBAR (statusbar.call), 1, qsodata.call);
  strcpy (qsodata.name,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.name_text)));
  gtk_statusbar_pop (GTK_STATUSBAR (statusbar.name), 1);
  gtk_statusbar_push (GTK_STATUSBAR (statusbar.name), 1, qsodata.name);
  strcpy (qsodata.qth, gtk_entry_get_text (GTK_ENTRY (qso_dialog.qth_text)));
  gtk_statusbar_pop (GTK_STATUSBAR (statusbar.qth), 1);
  gtk_statusbar_push (GTK_STATUSBAR (statusbar.qth), 1, qsodata.qth);
  strcpy (qsodata.rst_s,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.rst_s_text)));
  strcpy (qsodata.rst_r,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.rst_r_text)));
  strcpy (qsodata.notes,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.notes_text)));
  strcpy (qsodata.freq,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.freq_text)));

}

void toggle_call_dialog ()
{
	if (GTK_WIDGET_VISIBLE(qso_dialog.window))		// The Dialog is Visible, we save the coordinates and hite it
	{
	  gdk_window_get_root_origin (qso_dialog.window->window,
                              &x,
                              &y);
	  check_menu("/Window/QSO Details", 0);
	  gtk_widget_hide_all (qso_dialog.window);
	  set_values ();
	}
	else
	{
	  if (x != -1 && y != -1)
	     gtk_widget_set_uposition (GTK_WIDGET (qso_dialog.window), x, y);
             gtk_widget_show_all (GTK_WIDGET (qso_dialog.window));     // Show the logbook entry
	}
}
