/* gpsk31  - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 0.2.4 - May 2000
 *
 */

/*
 * text.C functions for the text widgets on the main window
 */

#include <gtk/gtk.h>
#include "text.h"
#include "globals.h"
#include <stdio.h>

GdkColor tx_window_color;              /* The used colors and fonts */
GdkColor rx_window_color_rx;
GdkColor rx_window_color_tx;
GdkFont  *tx_window_font;
GdkFont  *rx_window_font;

void text_allocate()
{
	GdkColormap *cmap;

        /* Allocate the 3 colors for the 2 text widgets */

          cmap = gdk_colormap_get_system ();

          gdk_color_parse (ini_settings.tx_window_color, &tx_window_color);
          if (!gdk_color_alloc (cmap, &tx_window_color))
             g_error ("Couldn't allocate color");

          gdk_color_parse (ini_settings.rx_window_color_rx, &rx_window_color_rx);
          if (!gdk_color_alloc (cmap, &rx_window_color_rx))
             g_error ("Couldn't allocate color");

          gdk_color_parse (ini_settings.rx_window_color_tx, &rx_window_color_tx);
          if (!gdk_color_alloc (cmap, &rx_window_color_tx))
             g_error ("Couldn't allocate color");

        /* Load the 2 fonts for the text widgets */

        tx_window_font = gdk_font_load (ini_settings.tx_window_font);
        rx_window_font = gdk_font_load (ini_settings.rx_window_font);
}

/*
 *  This functions adds an character to the rx window
 */


void put_rx_window (gchar *text, int txstate)
{
	rx_window_freeze (NULL);

	if (txstate == 1)
		gtk_text_insert (GTK_TEXT (main_screen.rxwindow),
                             rx_window_font, &rx_window_color_tx, 
                             NULL, text, -1);
        else
		gtk_text_insert (GTK_TEXT (main_screen.rxwindow),
                            rx_window_font, &rx_window_color_rx,
                             NULL, text, -1);

}

/*
 *   Put a char in the tx window
 */

void put_tx_window (gchar *text)
{
	gtk_text_backward_delete (GTK_TEXT (main_screen.txwindow), 1);
	gtk_text_insert (GTK_TEXT (main_screen.txwindow),
                             tx_window_font, &tx_window_color,
                             NULL, text, -1);
	gtk_text_insert (GTK_TEXT (main_screen.txwindow),
                             tx_window_font, &tx_window_color,
                             NULL, "_", -1);
}

void delete_char_tx_window ()
{
	gtk_text_backward_delete (GTK_TEXT (main_screen.txwindow), 2);
	gtk_text_insert (GTK_TEXT (main_screen.txwindow),
                             tx_window_font, &tx_window_color,
                             NULL, "_", -1);
}

/*
 * Draws the _ cursor
 */

void put_tx_window_cursor ()
{
	gtk_text_insert (GTK_TEXT (main_screen.txwindow),
                             tx_window_font, &tx_window_color,
                             NULL, "_", -1);
}

gint rx_window_freeze (gpointer data)
{
	static int is_freeze;
	float value = (gfloat) (GTK_TEXT (main_screen.rxwindow)->vadj->value);
	float upper = (gfloat) (GTK_TEXT (main_screen.rxwindow)->vadj->upper);
	float lower = (gfloat) (GTK_TEXT (main_screen.rxwindow)->vadj->lower);	
	int size;
	static float maxvalue;
	gdk_window_get_size (main_screen.rxwindow->window, NULL, &size);
	if (((upper-value)+6) <= size)  {
		//g_print ("NOT SCROLLED\n");
		if (is_freeze == 1) {
			is_freeze = 0;
			gtk_text_thaw (GTK_TEXT (main_screen.rxwindow));
		}
	}
	else
		{
		//g_print ("SCROLLED\n");
		if (is_freeze == 0) {
			is_freeze = 1;
			gtk_text_freeze (GTK_TEXT (main_screen.rxwindow));
		}
	}
	return TRUE;
}

