/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 2 "../build/source/cssparser/css_grammar.y"


#include <css_parser.h>
#include "css_lex.h"
#include <assert.h>

using namespace css_parser;

#line 17 "../build/source/cssparser/css_grammar.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    css_parseTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is css_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    css_parseARG_SDECL     A static variable declaration for the %extra_argument
**    css_parseARG_PDECL     A parameter declaration for the %extra_argument
**    css_parseARG_STORE     Code to store %extra_argument into yypParser
**    css_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 87
#define YYACTIONTYPE unsigned short int
#define css_parseTOKENTYPE css_yystype
typedef union {
  int yyinit;
  css_parseTOKENTYPE yy0;
  css_ruleset* yy31;
  css_simple_selector* yy49;
  css_property* yy76;
  css_properties* yy80;
  css_selectors* yy91;
  css_hex* yy104;
  css_selector* yy136;
  css_function* yy141;
  css_base* yy162;
  int yy173;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define css_parseARG_SDECL  parse_parm_s *parm ;
#define css_parseARG_PDECL , parse_parm_s *parm 
#define css_parseARG_FETCH  parse_parm_s *parm  = yypParser->parm 
#define css_parseARG_STORE yypParser->parm  = parm 
#define YYNSTATE 183
#define YYNRULE 103
#define YYERRORSYMBOL 43
#define YYERRSYMDT yy173
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (340)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    38,  180,  178,  182,  181,   23,   12,   13,  139,  140,
 /*    10 */    21,  137,  138,  136,  139,  140,   20,  137,  138,  175,
 /*    20 */    82,  179,  177,  176,   65,  123,  175,  152,  168,   66,
 /*    30 */   175,   63,  258,   59,  175,  258,  149,  175,  158,   99,
 /*    40 */    41,   60,   50,   51,   65,  100,   86,   55,  153,   66,
 /*    50 */    75,   63,  183,   59,  152,  170,   79,   95,  158,   58,
 /*    60 */   166,   60,   61,   64,  159,  175,   99,  139,  140,   19,
 /*    70 */   137,  138,  100,   86,   55,  153,   32,   45,   49,  175,
 /*    80 */    54,  146,   61,   64,  159,   24,   12,   13,  139,  140,
 /*    90 */    21,  137,  138,  136,  164,   12,   13,  139,  140,   21,
 /*   100 */   137,  138,  135,  167,  152,   71,   70,   72,   69,   68,
 /*   110 */    67,  124,   73,   74,  175,   52,   99,   50,   51,  152,
 /*   120 */     6,  169,  100,   86,   55,  153,  175,   65,  118,  175,
 /*   130 */   147,   99,   66,  120,   63,  173,   33,  100,   86,   55,
 /*   140 */   153,  158,   12,   13,  139,  140,   21,  137,  138,  134,
 /*   150 */    12,   13,  139,  140,   21,  137,  138,  133,  143,  144,
 /*   160 */   148,  141,  142,  175,   80,   61,   64,  159,   65,  174,
 /*   170 */    78,  118,   76,   66,  132,   63,  122,  175,   29,   98,
 /*   180 */   163,   30,  158,    3,  118,   77,  126,  123,  161,  122,
 /*   190 */    62,   31,  118,  163,   30,    5,   17,  122,   53,   28,
 /*   200 */   151,  163,   30,  161,  123,   62,   61,   64,  159,  175,
 /*   210 */    80,  118,  172,   93,    7,  156,  122,   62,   27,  150,
 /*   220 */   163,   30,  154,  118,  162,   18,  157,   84,  122,  160,
 /*   230 */    26,   62,  163,   30,    9,  156,  123,   62,   99,  130,
 /*   240 */    18,  157,   84,  123,  100,   86,   55,   56,  132,   48,
 /*   250 */   132,    2,  145,  157,   84,  129,  167,   57,   46,   43,
 /*   260 */    37,  287,   83,    5,   25,  175,   57,  157,   84,  168,
 /*   270 */    57,  128,   34,  157,   84,   87,   44,  132,  127,  125,
 /*   280 */    39,  121,  119,   11,  117,   40,  116,  115,  114,  113,
 /*   290 */   112,  111,  165,  110,  109,  108,  107,  106,  105,  104,
 /*   300 */    10,  103,  102,  155,   57,  101,  288,    4,   92,   91,
 /*   310 */    85,   90,   97,   96,   22,   36,   16,   15,   42,   35,
 /*   320 */    14,   94,   89,  288,   88,  288,  288,  288,  288,    1,
 /*   330 */   288,  288,  171,  288,  288,  131,    8,   47,  288,   81,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    50,    1,   52,    3,    4,   55,   56,   57,   58,   59,
 /*    10 */    60,   61,   62,   63,   58,   59,   60,   61,   62,    1,
 /*    20 */    70,   71,   72,   73,    2,   43,    1,    2,    1,    7,
 /*    30 */     1,    9,   10,   11,    1,   13,   18,    1,   16,   14,
 /*    40 */     7,   19,   15,   16,    2,   20,   21,   22,   23,    7,
 /*    50 */    28,    9,    0,   11,    2,   10,   11,   21,   16,   17,
 /*    60 */    78,   19,   40,   41,   42,    1,   14,   58,   59,   60,
 /*    70 */    61,   62,   20,   21,   22,   23,   24,   25,   26,    1,
 /*    80 */     2,   17,   40,   41,   42,   55,   56,   57,   58,   59,
 /*    90 */    60,   61,   62,   63,   13,   56,   57,   58,   59,   60,
 /*   100 */    61,   62,   63,    1,    2,   31,   32,   33,   34,   35,
 /*   110 */    36,   43,   38,   39,    1,    2,   14,   15,   16,    2,
 /*   120 */    81,   10,   20,   21,   22,   23,    1,    2,   44,    1,
 /*   130 */    17,   14,    7,   49,    9,    7,   68,   20,   21,   22,
 /*   140 */    23,   16,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   150 */    56,   57,   58,   59,   60,   61,   62,   63,   58,   59,
 /*   160 */     2,   61,   62,    1,    2,   40,   41,   42,    2,   41,
 /*   170 */    10,   44,   21,    7,   12,    9,   49,    1,   51,   21,
 /*   180 */    53,   54,   16,   69,   44,   10,   10,   43,   46,   49,
 /*   190 */    48,   51,   44,   53,   54,   81,   69,   49,   40,   51,
 /*   200 */     2,   53,   54,   46,   43,   48,   40,   41,   42,    1,
 /*   210 */     2,   44,   74,   75,   45,   46,   49,   48,   51,    2,
 /*   220 */    53,   54,   78,   44,   82,   83,   84,   85,   49,   46,
 /*   230 */    51,   48,   53,   54,   45,   46,   43,   48,   14,   78,
 /*   240 */    83,   84,   85,   43,   20,   21,   22,   11,   12,   11,
 /*   250 */    12,   69,    2,   84,   85,   74,    1,    2,   77,    2,
 /*   260 */    79,   64,   65,   81,   68,    1,    2,   84,   85,    1,
 /*   270 */     2,   78,   66,   84,   85,   66,   77,   12,   78,   68,
 /*   280 */    68,   68,   68,   68,   68,   80,   68,   68,   68,   68,
 /*   290 */    68,   68,   13,   68,   68,   68,   68,   68,   68,   68,
 /*   300 */    68,   68,   68,   68,    2,   68,   86,   68,   68,   68,
 /*   310 */    68,   68,   68,   68,   68,   68,   68,   68,   27,   68,
 /*   320 */    68,   68,   68,   86,   68,   86,   86,   86,   86,   67,
 /*   330 */    86,   86,   74,   86,   86,   74,   77,   77,   86,   76,
};
#define YY_SHIFT_USE_DFLT (-1)
#define YY_SHIFT_COUNT (125)
#define YY_SHIFT_MIN   (0)
#define YY_SHIFT_MAX   (302)
static const short yy_shift_ofst[] = {
 /*     0 */   291,   52,  102,  102,   25,  117,  117,   22,  268,   42,
 /*    10 */   125,  125,  224,  224,  264,  264,  264,  255,  166,  224,
 /*    20 */   224,  224,  162,   27,   27,  208,  279,  279,  279,  279,
 /*    30 */   302,  279,   -1,  128,    0,   36,  208,  238,  236,  208,
 /*    40 */   265,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
 /*    50 */    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
 /*    60 */    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
 /*    70 */    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
 /*    80 */    -1,   -1,   -1,   -1,   74,  113,  158,    0,  176,   33,
 /*    90 */    64,   18,   78,   45,   29,  257,   29,   29,  250,  217,
 /*   100 */   198,   29,   29,   29,   29,   29,   29,   29,   29,   29,
 /*   110 */    29,   29,   29,   29,   29,   29,   29,   29,  151,   29,
 /*   120 */   175,   29,  160,   81,  111,   29,
};
#define YY_REDUCE_USE_DFLT (-51)
#define YY_REDUCE_COUNT (83)
#define YY_REDUCE_MIN   (-50)
#define YY_REDUCE_MAX   (263)
static const short yy_reduce_ofst[] = {
 /*     0 */   197,  -50,   39,   39,   30,   94,   86,  142,  127,  157,
 /*    10 */   189,  169,    9,  -44,  179,  167,  148,  140,  183,  100,
 /*    20 */   100,  100,  181,  182,  114,  138,  200,  193,  161,  144,
 /*    30 */    84,  -18,   68,  263,  262,  205,  261,  260,  259,  258,
 /*    40 */   199,  256,  254,  253,  252,  251,  249,  248,  247,  246,
 /*    50 */   245,  244,  243,  242,  241,  240,  239,  237,  235,  234,
 /*    60 */   233,  232,  231,  230,  229,  228,  227,  226,  225,  223,
 /*    70 */   222,  221,  220,  219,  218,  216,  215,  214,  213,  212,
 /*    80 */   211,  196,  209,  206,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   192,  286,  246,  248,  286,  286,  286,  265,  217,  265,
 /*    10 */   265,  265,  238,  236,  217,  217,  217,  217,  265,  239,
 /*    20 */   237,  240,  286,  245,  247,  201,  286,  286,  286,  286,
 /*    30 */   255,  286,  184,  286,  194,  215,  286,  286,  286,  286,
 /*    40 */   286,  184,  184,  184,  184,  184,  184,  184,  184,  184,
 /*    50 */   184,  184,  184,  184,  184,  184,  184,  184,  184,  184,
 /*    60 */   184,  184,  184,  184,  184,  184,  184,  184,  184,  184,
 /*    70 */   184,  184,  184,  184,  184,  184,  184,  184,  184,  184,
 /*    80 */   184,  184,  188,  188,  286,  286,  286,  195,  286,  286,
 /*    90 */   286,  286,  286,  286,  216,  286,  250,  249,  286,  286,
 /*   100 */   286,  257,  268,  267,  281,  280,  279,  278,  277,  276,
 /*   110 */   275,  274,  273,  272,  271,  270,  269,  259,  286,  252,
 /*   120 */   254,  251,  253,  286,  286,  200,  193,  214,  213,  211,
 /*   130 */   212,  210,  283,  242,  244,  243,  241,  235,  234,  233,
 /*   140 */   232,  231,  230,  229,  228,  227,  226,  225,  224,  223,
 /*   150 */   222,  221,  220,  219,  208,  282,  260,  266,  264,  263,
 /*   160 */   262,  261,  256,  218,  285,  284,  209,  187,  186,  207,
 /*   170 */   206,  203,  202,  205,  204,  185,  199,  198,  197,  196,
 /*   180 */   191,  190,  189,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  css_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void css_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "S",             "IDENT",         "CDO",         
  "CDC",           "INCLUDES",      "DASHMATCH",     "STRING",      
  "INVALID",       "HEXCOLOR",      "SEMICOLON",     "COMMA",       
  "LBRACE",        "RBRACE",        "HASH",          "GREATER",     
  "PLUS",          "CLPARENTH",     "RBRACK",        "SLASH",       
  "DOT",           "COLON",         "LBRACK",        "ASTERISK",    
  "IMPORT_SYM",    "PAGE_SYM",      "MEDIA_SYM",     "CHARSET_SYM", 
  "IMPORTANT_SYM",  "FONTFACE_SYM",  "NAMESPACE_SYM",  "EMS",         
  "EXS",           "LENGTH",        "ANGLE",         "TIME",        
  "FREQ",          "DIMENSION",     "PERCENTAGE",    "NUMBER",      
  "FUNCTION",      "URI",           "MINUS",         "error",       
  "property",      "expr",          "term",          "hexcolor",    
  "function",      "declaration",   "selectors",     "maybe_declarations",
  "ruleset",       "declarations",  "declaration_list",  "selector",    
  "universal_selector",  "type_selector",  "class_selector",  "id_selector", 
  "simple_selectors",  "pseudo_selector",  "attribute_selector",  "simple_selector",
  "stylesheet",    "maybe_charset",  "maybe_sgml",    "maybe_rules", 
  "maybe_space",   "space",         "rule",          "import",      
  "media",         "page",          "medium",        "maybe_medium",
  "uri_or_string",  "block_start",   "block_end",     "media_list",  
  "maybe_pseudo_page",  "combinator",    "maybe_prio",    "operator",    
  "unary_operator",  "maybe_unary_operator",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "stylesheet ::= maybe_charset maybe_sgml maybe_rules",
 /*   1 */ "maybe_space ::=",
 /*   2 */ "maybe_space ::= maybe_space S",
 /*   3 */ "space ::= S",
 /*   4 */ "space ::= space S",
 /*   5 */ "maybe_sgml ::=",
 /*   6 */ "maybe_sgml ::= maybe_sgml CDO",
 /*   7 */ "maybe_sgml ::= maybe_sgml CDC",
 /*   8 */ "maybe_sgml ::= maybe_sgml S",
 /*   9 */ "maybe_charset ::=",
 /*  10 */ "maybe_charset ::= CHARSET_SYM maybe_space STRING maybe_space SEMICOLON",
 /*  11 */ "maybe_rules ::=",
 /*  12 */ "maybe_rules ::= maybe_rules rule maybe_sgml",
 /*  13 */ "rule ::= import",
 /*  14 */ "rule ::= ruleset",
 /*  15 */ "rule ::= media",
 /*  16 */ "rule ::= page",
 /*  17 */ "medium ::= IDENT maybe_space",
 /*  18 */ "maybe_medium ::=",
 /*  19 */ "maybe_medium ::= medium",
 /*  20 */ "maybe_medium ::= maybe_medium COMMA maybe_space medium",
 /*  21 */ "uri_or_string ::= URI",
 /*  22 */ "uri_or_string ::= STRING",
 /*  23 */ "import ::= IMPORT_SYM maybe_space uri_or_string maybe_space maybe_medium SEMICOLON",
 /*  24 */ "import ::= IMPORT_SYM error SEMICOLON",
 /*  25 */ "ruleset ::= selectors block_start maybe_declarations block_end",
 /*  26 */ "ruleset ::= selectors block_start space maybe_declarations block_end",
 /*  27 */ "media_list ::= media_list COMMA maybe_space medium",
 /*  28 */ "media_list ::= medium",
 /*  29 */ "media ::= MEDIA_SYM maybe_space media_list block_start maybe_space maybe_declarations block_end",
 /*  30 */ "media ::= MEDIA_SYM maybe_space block_start maybe_space maybe_declarations block_end",
 /*  31 */ "page ::= PAGE_SYM maybe_space maybe_pseudo_page block_start maybe_space maybe_declarations block_end",
 /*  32 */ "maybe_pseudo_page ::=",
 /*  33 */ "maybe_pseudo_page ::= COLON IDENT maybe_space",
 /*  34 */ "maybe_declarations ::=",
 /*  35 */ "maybe_declarations ::= declarations",
 /*  36 */ "universal_selector ::= ASTERISK",
 /*  37 */ "type_selector ::= IDENT",
 /*  38 */ "class_selector ::= DOT IDENT",
 /*  39 */ "id_selector ::= HASH IDENT",
 /*  40 */ "attribute_selector ::= LBRACK maybe_space IDENT maybe_space RBRACK",
 /*  41 */ "pseudo_selector ::= COLON IDENT",
 /*  42 */ "pseudo_selector ::= COLON FUNCTION maybe_space CLPARENTH",
 /*  43 */ "pseudo_selector ::= COLON FUNCTION maybe_space IDENT maybe_space CLPARENTH",
 /*  44 */ "pseudo_selector ::= COLON COLON IDENT",
 /*  45 */ "simple_selectors ::= simple_selectors id_selector",
 /*  46 */ "simple_selectors ::= simple_selectors class_selector",
 /*  47 */ "simple_selectors ::= simple_selectors attribute_selector",
 /*  48 */ "simple_selectors ::= simple_selectors pseudo_selector",
 /*  49 */ "simple_selectors ::= id_selector",
 /*  50 */ "simple_selectors ::= class_selector",
 /*  51 */ "simple_selectors ::= attribute_selector",
 /*  52 */ "simple_selectors ::= pseudo_selector",
 /*  53 */ "simple_selector ::= type_selector",
 /*  54 */ "simple_selector ::= type_selector simple_selectors",
 /*  55 */ "simple_selector ::= universal_selector",
 /*  56 */ "simple_selector ::= universal_selector simple_selectors",
 /*  57 */ "simple_selector ::= simple_selectors",
 /*  58 */ "selector ::= simple_selector",
 /*  59 */ "selector ::= selector combinator simple_selector",
 /*  60 */ "selector ::= selector space simple_selector",
 /*  61 */ "selector ::= selector space combinator simple_selector",
 /*  62 */ "selectors ::= selector",
 /*  63 */ "selectors ::= selector space",
 /*  64 */ "selectors ::= selectors COMMA maybe_space selector",
 /*  65 */ "selectors ::= selectors COMMA maybe_space selector space",
 /*  66 */ "combinator ::= PLUS maybe_space",
 /*  67 */ "combinator ::= GREATER maybe_space",
 /*  68 */ "declaration_list ::= declaration SEMICOLON maybe_space",
 /*  69 */ "declaration_list ::= declaration_list declaration SEMICOLON maybe_space",
 /*  70 */ "declarations ::= declaration",
 /*  71 */ "declarations ::= declaration_list declaration",
 /*  72 */ "declarations ::= declaration_list",
 /*  73 */ "declaration ::= property COLON maybe_space expr maybe_prio",
 /*  74 */ "property ::= IDENT maybe_space",
 /*  75 */ "maybe_prio ::=",
 /*  76 */ "maybe_prio ::= IMPORTANT_SYM maybe_space",
 /*  77 */ "expr ::= term",
 /*  78 */ "expr ::= expr term",
 /*  79 */ "expr ::= expr operator term",
 /*  80 */ "unary_operator ::= MINUS",
 /*  81 */ "unary_operator ::= PLUS",
 /*  82 */ "maybe_unary_operator ::=",
 /*  83 */ "maybe_unary_operator ::= unary_operator",
 /*  84 */ "operator ::= SLASH maybe_space",
 /*  85 */ "operator ::= COMMA maybe_space",
 /*  86 */ "term ::= maybe_unary_operator NUMBER maybe_space",
 /*  87 */ "term ::= maybe_unary_operator PERCENTAGE maybe_space",
 /*  88 */ "term ::= maybe_unary_operator LENGTH maybe_space",
 /*  89 */ "term ::= maybe_unary_operator EMS maybe_space",
 /*  90 */ "term ::= maybe_unary_operator EXS maybe_space",
 /*  91 */ "term ::= maybe_unary_operator ANGLE maybe_space",
 /*  92 */ "term ::= maybe_unary_operator TIME maybe_space",
 /*  93 */ "term ::= maybe_unary_operator FREQ maybe_space",
 /*  94 */ "term ::= STRING maybe_space",
 /*  95 */ "term ::= IDENT maybe_space",
 /*  96 */ "term ::= URI maybe_space",
 /*  97 */ "term ::= HEXCOLOR maybe_space",
 /*  98 */ "term ::= function maybe_space",
 /*  99 */ "function ::= FUNCTION maybe_space expr CLPARENTH maybe_space",
 /* 100 */ "block_start ::= LBRACE",
 /* 101 */ "block_end ::= RBRACE",
 /* 102 */ "block_end ::= error RBRACE",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to css_parse and css_parseFree.
*/
void *css_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  css_parseARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from css_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void css_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int css_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   css_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
   css_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 64, 3 },
  { 68, 0 },
  { 68, 2 },
  { 69, 1 },
  { 69, 2 },
  { 66, 0 },
  { 66, 2 },
  { 66, 2 },
  { 66, 2 },
  { 65, 0 },
  { 65, 5 },
  { 67, 0 },
  { 67, 3 },
  { 70, 1 },
  { 70, 1 },
  { 70, 1 },
  { 70, 1 },
  { 74, 2 },
  { 75, 0 },
  { 75, 1 },
  { 75, 4 },
  { 76, 1 },
  { 76, 1 },
  { 71, 6 },
  { 71, 3 },
  { 52, 4 },
  { 52, 5 },
  { 79, 4 },
  { 79, 1 },
  { 72, 7 },
  { 72, 6 },
  { 73, 7 },
  { 80, 0 },
  { 80, 3 },
  { 51, 0 },
  { 51, 1 },
  { 56, 1 },
  { 57, 1 },
  { 58, 2 },
  { 59, 2 },
  { 62, 5 },
  { 61, 2 },
  { 61, 4 },
  { 61, 6 },
  { 61, 3 },
  { 60, 2 },
  { 60, 2 },
  { 60, 2 },
  { 60, 2 },
  { 60, 1 },
  { 60, 1 },
  { 60, 1 },
  { 60, 1 },
  { 63, 1 },
  { 63, 2 },
  { 63, 1 },
  { 63, 2 },
  { 63, 1 },
  { 55, 1 },
  { 55, 3 },
  { 55, 3 },
  { 55, 4 },
  { 50, 1 },
  { 50, 2 },
  { 50, 4 },
  { 50, 5 },
  { 81, 2 },
  { 81, 2 },
  { 54, 3 },
  { 54, 4 },
  { 53, 1 },
  { 53, 2 },
  { 53, 1 },
  { 49, 5 },
  { 44, 2 },
  { 82, 0 },
  { 82, 2 },
  { 45, 1 },
  { 45, 2 },
  { 45, 3 },
  { 84, 1 },
  { 84, 1 },
  { 85, 0 },
  { 85, 1 },
  { 83, 2 },
  { 83, 2 },
  { 46, 3 },
  { 46, 3 },
  { 46, 3 },
  { 46, 3 },
  { 46, 3 },
  { 46, 3 },
  { 46, 3 },
  { 46, 3 },
  { 46, 2 },
  { 46, 2 },
  { 46, 2 },
  { 46, 2 },
  { 46, 2 },
  { 48, 5 },
  { 77, 1 },
  { 78, 1 },
  { 78, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  css_parseARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 25: /* ruleset ::= selectors block_start maybe_declarations block_end */
#line 113 "../build/source/cssparser/css_grammar.y"
{
	css_ruleset *ruleset = new(parm) css_ruleset(); 
	ruleset->setSelectors(yymsp[-3].minor.yy91->selectors_);
	if (yymsp[-1].minor.yy80) ruleset->addProperties(yymsp[-1].minor.yy80);
	yygotominor.yy31 = ruleset;

	parm->page->addRuleset(ruleset);
}
#line 995 "../build/source/cssparser/css_grammar.c"
        break;
      case 26: /* ruleset ::= selectors block_start space maybe_declarations block_end */
#line 122 "../build/source/cssparser/css_grammar.y"
{
	css_ruleset *ruleset = new(parm) css_ruleset(); 
	ruleset->setSelectors(yymsp[-4].minor.yy91->selectors_);
	if (yymsp[-1].minor.yy80) ruleset->addProperties(yymsp[-1].minor.yy80);
	yygotominor.yy31 = ruleset;

	parm->page->addRuleset(ruleset);
}
#line 1007 "../build/source/cssparser/css_grammar.c"
        break;
      case 34: /* maybe_declarations ::= */
#line 142 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy80 = 0; }
#line 1012 "../build/source/cssparser/css_grammar.c"
        break;
      case 35: /* maybe_declarations ::= declarations */
#line 143 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy80 = yymsp[0].minor.yy80; }
#line 1017 "../build/source/cssparser/css_grammar.c"
        break;
      case 36: /* universal_selector ::= ASTERISK */
      case 37: /* type_selector ::= IDENT */ yytestcase(yyruleno==37);
      case 38: /* class_selector ::= DOT IDENT */ yytestcase(yyruleno==38);
      case 39: /* id_selector ::= HASH IDENT */ yytestcase(yyruleno==39);
      case 41: /* pseudo_selector ::= COLON IDENT */ yytestcase(yyruleno==41);
      case 44: /* pseudo_selector ::= COLON COLON IDENT */ yytestcase(yyruleno==44);
#line 145 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy49 = new(parm) css_simple_selector(yymsp[0].minor.yy0.string); }
#line 1027 "../build/source/cssparser/css_grammar.c"
        break;
      case 40: /* attribute_selector ::= LBRACK maybe_space IDENT maybe_space RBRACK */
#line 150 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy49 = new(parm) css_simple_selector(yymsp[-2].minor.yy0.string); }
#line 1032 "../build/source/cssparser/css_grammar.c"
        break;
      case 45: /* simple_selectors ::= simple_selectors id_selector */
      case 46: /* simple_selectors ::= simple_selectors class_selector */ yytestcase(yyruleno==46);
      case 47: /* simple_selectors ::= simple_selectors attribute_selector */ yytestcase(yyruleno==47);
      case 48: /* simple_selectors ::= simple_selectors pseudo_selector */ yytestcase(yyruleno==48);
#line 157 "../build/source/cssparser/css_grammar.y"
{ yymsp[-1].minor.yy136->addSimpleSelector(yymsp[0].minor.yy49); yygotominor.yy136 = yymsp[-1].minor.yy136; }
#line 1040 "../build/source/cssparser/css_grammar.c"
        break;
      case 49: /* simple_selectors ::= id_selector */
      case 50: /* simple_selectors ::= class_selector */ yytestcase(yyruleno==50);
      case 51: /* simple_selectors ::= attribute_selector */ yytestcase(yyruleno==51);
      case 52: /* simple_selectors ::= pseudo_selector */ yytestcase(yyruleno==52);
      case 53: /* simple_selector ::= type_selector */ yytestcase(yyruleno==53);
      case 55: /* simple_selector ::= universal_selector */ yytestcase(yyruleno==55);
#line 161 "../build/source/cssparser/css_grammar.y"
{
	css_selector* selector = new(parm) css_selector(); 
	selector->addSimpleSelector(yymsp[0].minor.yy49);
	yygotominor.yy136 = selector;
}
#line 1054 "../build/source/cssparser/css_grammar.c"
        break;
      case 54: /* simple_selector ::= type_selector simple_selectors */
      case 56: /* simple_selector ::= universal_selector simple_selectors */ yytestcase(yyruleno==56);
#line 187 "../build/source/cssparser/css_grammar.y"
{
	yymsp[0].minor.yy136->prependSimpleSelector(yymsp[-1].minor.yy49);
	yygotominor.yy136 = yymsp[0].minor.yy136;
}
#line 1063 "../build/source/cssparser/css_grammar.c"
        break;
      case 57: /* simple_selector ::= simple_selectors */
#line 200 "../build/source/cssparser/css_grammar.y"
{
	yygotominor.yy136 = yymsp[0].minor.yy136;
}
#line 1070 "../build/source/cssparser/css_grammar.c"
        break;
      case 58: /* selector ::= simple_selector */
#line 205 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy136 = yymsp[0].minor.yy136; }
#line 1075 "../build/source/cssparser/css_grammar.c"
        break;
      case 59: /* selector ::= selector combinator simple_selector */
#line 206 "../build/source/cssparser/css_grammar.y"
{ 
	yymsp[-2].minor.yy136->addSelector(yymsp[0].minor.yy136);
	yygotominor.yy136 = yymsp[-2].minor.yy136;
}
#line 1083 "../build/source/cssparser/css_grammar.c"
        break;
      case 60: /* selector ::= selector space simple_selector */
#line 210 "../build/source/cssparser/css_grammar.y"
{
	yymsp[-2].minor.yy136->addSelector(yymsp[0].minor.yy136);
	yygotominor.yy136 = yymsp[-2].minor.yy136;
}
#line 1091 "../build/source/cssparser/css_grammar.c"
        break;
      case 61: /* selector ::= selector space combinator simple_selector */
#line 214 "../build/source/cssparser/css_grammar.y"
{
	yymsp[-3].minor.yy136->addSelector(yymsp[0].minor.yy136);
	yygotominor.yy136 = yymsp[-3].minor.yy136;
}
#line 1099 "../build/source/cssparser/css_grammar.c"
        break;
      case 62: /* selectors ::= selector */
#line 219 "../build/source/cssparser/css_grammar.y"
{
	css_selectors* selectors = new(parm) css_selectors(); 
	selectors->addSelector(yymsp[0].minor.yy136);
	yygotominor.yy91 = selectors;
}
#line 1108 "../build/source/cssparser/css_grammar.c"
        break;
      case 63: /* selectors ::= selector space */
#line 225 "../build/source/cssparser/css_grammar.y"
{
	css_selectors* selectors = new(parm) css_selectors(); 
	selectors->addSelector(yymsp[-1].minor.yy136);
	yygotominor.yy91 = selectors;
}
#line 1117 "../build/source/cssparser/css_grammar.c"
        break;
      case 64: /* selectors ::= selectors COMMA maybe_space selector */
#line 231 "../build/source/cssparser/css_grammar.y"
{
	yymsp[-3].minor.yy91->addSelector(yymsp[0].minor.yy136);
	yygotominor.yy91 = yymsp[-3].minor.yy91;
}
#line 1125 "../build/source/cssparser/css_grammar.c"
        break;
      case 65: /* selectors ::= selectors COMMA maybe_space selector space */
#line 236 "../build/source/cssparser/css_grammar.y"
{
	yymsp[-4].minor.yy91->addSelector(yymsp[-1].minor.yy136);
	yygotominor.yy91 = yymsp[-4].minor.yy91;
}
#line 1133 "../build/source/cssparser/css_grammar.c"
        break;
      case 68: /* declaration_list ::= declaration SEMICOLON maybe_space */
#line 245 "../build/source/cssparser/css_grammar.y"
{
	css_properties* properties = new(parm) css_properties(); 
	if (yymsp[-2].minor.yy76) properties->addProperty(yymsp[-2].minor.yy76);
	yygotominor.yy80 = properties;
}
#line 1142 "../build/source/cssparser/css_grammar.c"
        break;
      case 69: /* declaration_list ::= declaration_list declaration SEMICOLON maybe_space */
#line 250 "../build/source/cssparser/css_grammar.y"
{
	if (yymsp[-2].minor.yy76) yymsp[-3].minor.yy80->addProperty(yymsp[-2].minor.yy76);
	yygotominor.yy80 = yymsp[-3].minor.yy80;
}
#line 1150 "../build/source/cssparser/css_grammar.c"
        break;
      case 70: /* declarations ::= declaration */
#line 255 "../build/source/cssparser/css_grammar.y"
{
	css_properties* properties = new(parm) css_properties(); 
	if (yymsp[0].minor.yy76) properties->addProperty(yymsp[0].minor.yy76);
	yygotominor.yy80 = properties;
}
#line 1159 "../build/source/cssparser/css_grammar.c"
        break;
      case 71: /* declarations ::= declaration_list declaration */
#line 260 "../build/source/cssparser/css_grammar.y"
{
	if (yymsp[0].minor.yy76) yymsp[-1].minor.yy80->addProperty(yymsp[0].minor.yy76);
	yygotominor.yy80 = yymsp[-1].minor.yy80;
}
#line 1167 "../build/source/cssparser/css_grammar.c"
        break;
      case 72: /* declarations ::= declaration_list */
#line 264 "../build/source/cssparser/css_grammar.y"
{
	yygotominor.yy80 = yymsp[0].minor.yy80;
}
#line 1174 "../build/source/cssparser/css_grammar.c"
        break;
      case 73: /* declaration ::= property COLON maybe_space expr maybe_prio */
#line 268 "../build/source/cssparser/css_grammar.y"
{
  if (strcmp(yymsp[-4].minor.yy76->name_, "color") == 0 || strcmp(yymsp[-4].minor.yy76->name_, "background-color") == 0){
		yymsp[-4].minor.yy76->addValue(yymsp[-1].minor.yy162);
		yygotominor.yy76 = yymsp[-4].minor.yy76;
	}else{
		yygotominor.yy76 = 0;
	}
}
#line 1186 "../build/source/cssparser/css_grammar.c"
        break;
      case 74: /* property ::= IDENT maybe_space */
#line 277 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy76 = new(parm) css_property(yymsp[-1].minor.yy0.string);}
#line 1191 "../build/source/cssparser/css_grammar.c"
        break;
      case 77: /* expr ::= term */
#line 283 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy162 = yymsp[0].minor.yy162; }
#line 1196 "../build/source/cssparser/css_grammar.c"
        break;
      case 78: /* expr ::= expr term */
#line 284 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy162 = yymsp[-1].minor.yy162; yygotominor.yy162 = yymsp[0].minor.yy162; }
#line 1201 "../build/source/cssparser/css_grammar.c"
        break;
      case 79: /* expr ::= expr operator term */
#line 285 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy162 = yymsp[-2].minor.yy162; yygotominor.yy162 = yymsp[0].minor.yy162; }
#line 1206 "../build/source/cssparser/css_grammar.c"
        break;
      case 86: /* term ::= maybe_unary_operator NUMBER maybe_space */
#line 296 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy162 = new(parm) css_number(yymsp[-1].minor.yy0.number); }
#line 1211 "../build/source/cssparser/css_grammar.c"
        break;
      case 87: /* term ::= maybe_unary_operator PERCENTAGE maybe_space */
      case 88: /* term ::= maybe_unary_operator LENGTH maybe_space */ yytestcase(yyruleno==88);
      case 89: /* term ::= maybe_unary_operator EMS maybe_space */ yytestcase(yyruleno==89);
      case 90: /* term ::= maybe_unary_operator EXS maybe_space */ yytestcase(yyruleno==90);
      case 91: /* term ::= maybe_unary_operator ANGLE maybe_space */ yytestcase(yyruleno==91);
      case 92: /* term ::= maybe_unary_operator TIME maybe_space */ yytestcase(yyruleno==92);
      case 93: /* term ::= maybe_unary_operator FREQ maybe_space */ yytestcase(yyruleno==93);
      case 96: /* term ::= URI maybe_space */ yytestcase(yyruleno==96);
#line 297 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy162 = 0; }
#line 1223 "../build/source/cssparser/css_grammar.c"
        break;
      case 94: /* term ::= STRING maybe_space */
      case 95: /* term ::= IDENT maybe_space */ yytestcase(yyruleno==95);
#line 304 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy162 = new(parm) css_string(yymsp[-1].minor.yy0.string); }
#line 1229 "../build/source/cssparser/css_grammar.c"
        break;
      case 97: /* term ::= HEXCOLOR maybe_space */
#line 307 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy162 = new(parm) css_hex(yymsp[-1].minor.yy0.string); }
#line 1234 "../build/source/cssparser/css_grammar.c"
        break;
      case 98: /* term ::= function maybe_space */
#line 308 "../build/source/cssparser/css_grammar.y"
{ yygotominor.yy162 = yymsp[-1].minor.yy141; }
#line 1239 "../build/source/cssparser/css_grammar.c"
        break;
      case 99: /* function ::= FUNCTION maybe_space expr CLPARENTH maybe_space */
#line 311 "../build/source/cssparser/css_grammar.y"
{
	css_function* function = new(parm) css_function(yymsp[-4].minor.yy0.string); 
	function->addArgument(yymsp[-2].minor.yy162);
	yygotominor.yy141 = function;
}
#line 1248 "../build/source/cssparser/css_grammar.c"
        break;
      default:
      /* (0) stylesheet ::= maybe_charset maybe_sgml maybe_rules */ yytestcase(yyruleno==0);
      /* (1) maybe_space ::= */ yytestcase(yyruleno==1);
      /* (2) maybe_space ::= maybe_space S */ yytestcase(yyruleno==2);
      /* (3) space ::= S */ yytestcase(yyruleno==3);
      /* (4) space ::= space S */ yytestcase(yyruleno==4);
      /* (5) maybe_sgml ::= */ yytestcase(yyruleno==5);
      /* (6) maybe_sgml ::= maybe_sgml CDO */ yytestcase(yyruleno==6);
      /* (7) maybe_sgml ::= maybe_sgml CDC */ yytestcase(yyruleno==7);
      /* (8) maybe_sgml ::= maybe_sgml S */ yytestcase(yyruleno==8);
      /* (9) maybe_charset ::= */ yytestcase(yyruleno==9);
      /* (10) maybe_charset ::= CHARSET_SYM maybe_space STRING maybe_space SEMICOLON */ yytestcase(yyruleno==10);
      /* (11) maybe_rules ::= */ yytestcase(yyruleno==11);
      /* (12) maybe_rules ::= maybe_rules rule maybe_sgml */ yytestcase(yyruleno==12);
      /* (13) rule ::= import */ yytestcase(yyruleno==13);
      /* (14) rule ::= ruleset */ yytestcase(yyruleno==14);
      /* (15) rule ::= media */ yytestcase(yyruleno==15);
      /* (16) rule ::= page */ yytestcase(yyruleno==16);
      /* (17) medium ::= IDENT maybe_space */ yytestcase(yyruleno==17);
      /* (18) maybe_medium ::= */ yytestcase(yyruleno==18);
      /* (19) maybe_medium ::= medium */ yytestcase(yyruleno==19);
      /* (20) maybe_medium ::= maybe_medium COMMA maybe_space medium */ yytestcase(yyruleno==20);
      /* (21) uri_or_string ::= URI */ yytestcase(yyruleno==21);
      /* (22) uri_or_string ::= STRING */ yytestcase(yyruleno==22);
      /* (23) import ::= IMPORT_SYM maybe_space uri_or_string maybe_space maybe_medium SEMICOLON */ yytestcase(yyruleno==23);
      /* (24) import ::= IMPORT_SYM error SEMICOLON */ yytestcase(yyruleno==24);
      /* (27) media_list ::= media_list COMMA maybe_space medium */ yytestcase(yyruleno==27);
      /* (28) media_list ::= medium */ yytestcase(yyruleno==28);
      /* (29) media ::= MEDIA_SYM maybe_space media_list block_start maybe_space maybe_declarations block_end */ yytestcase(yyruleno==29);
      /* (30) media ::= MEDIA_SYM maybe_space block_start maybe_space maybe_declarations block_end */ yytestcase(yyruleno==30);
      /* (31) page ::= PAGE_SYM maybe_space maybe_pseudo_page block_start maybe_space maybe_declarations block_end */ yytestcase(yyruleno==31);
      /* (32) maybe_pseudo_page ::= */ yytestcase(yyruleno==32);
      /* (33) maybe_pseudo_page ::= COLON IDENT maybe_space */ yytestcase(yyruleno==33);
      /* (42) pseudo_selector ::= COLON FUNCTION maybe_space CLPARENTH */ yytestcase(yyruleno==42);
      /* (43) pseudo_selector ::= COLON FUNCTION maybe_space IDENT maybe_space CLPARENTH */ yytestcase(yyruleno==43);
      /* (66) combinator ::= PLUS maybe_space */ yytestcase(yyruleno==66);
      /* (67) combinator ::= GREATER maybe_space */ yytestcase(yyruleno==67);
      /* (75) maybe_prio ::= */ yytestcase(yyruleno==75);
      /* (76) maybe_prio ::= IMPORTANT_SYM maybe_space */ yytestcase(yyruleno==76);
      /* (80) unary_operator ::= MINUS */ yytestcase(yyruleno==80);
      /* (81) unary_operator ::= PLUS */ yytestcase(yyruleno==81);
      /* (82) maybe_unary_operator ::= */ yytestcase(yyruleno==82);
      /* (83) maybe_unary_operator ::= unary_operator */ yytestcase(yyruleno==83);
      /* (84) operator ::= SLASH maybe_space */ yytestcase(yyruleno==84);
      /* (85) operator ::= COMMA maybe_space */ yytestcase(yyruleno==85);
      /* (100) block_start ::= LBRACE */ yytestcase(yyruleno==100);
      /* (101) block_end ::= RBRACE */ yytestcase(yyruleno==101);
      /* (102) block_end ::= error RBRACE */ yytestcase(yyruleno==102);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  css_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  css_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  css_parseARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 67 "../build/source/cssparser/css_grammar.y"

	printf("Error: %s\n", yyTokenName[yymajor]);
#line 1360 "../build/source/cssparser/css_grammar.c"
  css_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  css_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  css_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "css_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void css_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  css_parseTOKENTYPE yyminor       /* The value for the token */
  css_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  css_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
