/***************************************************************************
                          gpc_film.h  -  Current film description
                             -------------------
    begin                : Wed May 17 2000
    copyright            : (C) 2000 by Thierry Florac
    email                : tflorac@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GPC_FILM_H
#define GPC_FILM_H

#include "pg_connection.h"
#include "pg_query.h"


typedef struct _GpcFilmInfos GpcFilmInfos;


GpcFilmInfos *gpc_film_infos_new (void);
GpcFilmInfos *gpc_film_get_infos (pgConnection *connection, gint ID);


gint     gpc_film_get_id_from_path (pgConnection *connection, gchar *path);
gboolean gpc_film_exists (pgConnection *connection, gchar *path);
gint     gpc_film_append (pgConnection *connection, gchar *path);
gint     gpc_film_append_without_update (pgConnection *connection, gchar *path);
gboolean gpc_film_update_with_path (pgConnection *connection, gchar *path);
gboolean gpc_film_update (pgConnection *connection, gint ID);
gboolean gpc_film_delete (pgConnection *connection, gint ID);

pgQuery* gpc_film_get_list (pgConnection *connection);
pgQuery* gpc_film_get_list_where (pgConnection *connection, gchar *where);

gint   gpc_film_get_id (GpcFilmInfos *infos);
gchar* gpc_film_get_pathname (GpcFilmInfos *infos);
gchar* gpc_film_get_full_pathname (GpcFilmInfos *infos);
gchar* gpc_film_get_kind (GpcFilmInfos *infos);
gchar* gpc_film_get_number (GpcFilmInfos *infos);
gchar* gpc_film_get_maker (GpcFilmInfos *infos);
gchar* gpc_film_get_model (GpcFilmInfos *infos);
gshort gpc_film_get_iso (GpcFilmInfos *infos);
gshort gpc_film_get_size (GpcFilmInfos *infos);
gchar* gpc_film_get_camera_maker (GpcFilmInfos *infos);
gchar* gpc_film_get_camera_model (GpcFilmInfos *infos);
gchar* gpc_film_get_period (GpcFilmInfos *infos);
gchar* gpc_film_get_description (GpcFilmInfos *infos);
GList* gpc_film_get_keywords (GpcFilmInfos *infos);

void gpc_film_set_pathname (GpcFilmInfos *infos, gchar *value);
void gpc_film_set_kind (GpcFilmInfos *infos, gchar *value);
void gpc_film_set_number (GpcFilmInfos *infos, gchar *value);
void gpc_film_set_maker (GpcFilmInfos *infos, gchar *value);
void gpc_film_set_model (GpcFilmInfos *infos, gchar *value);
void gpc_film_set_iso (GpcFilmInfos *infos, gshort value);
void gpc_film_set_size (GpcFilmInfos *infos, gshort value);
void gpc_film_set_camera_maker (GpcFilmInfos *infos, gchar *value);
void gpc_film_set_camera_model (GpcFilmInfos *infos, gchar *value);
void gpc_film_set_period (GpcFilmInfos *infos, gchar *value);
void gpc_film_set_description (GpcFilmInfos *infos, gchar *value);
void gpc_film_set_keywords (GpcFilmInfos *infos, GList *value, gboolean free_it);

gboolean gpc_film_infos_store (pgConnection *connection, GpcFilmInfos *infos);
gboolean gpc_film_infos_store_keywords (pgConnection *connection, GpcFilmInfos *infos);
gboolean gpc_film_store_references (pgConnection *connection, GpcFilmInfos *infos);

void gpc_film_infos_free (GpcFilmInfos *infos);
void gpc_film_infos_show (GpcFilmInfos *infos);

#endif
