%option noyywrap

%{
#include "gparser.h"
int line = 0;
int col  = 0;
%}

%%

[a-zA-Z][a-zA-Z0-9]*	{ col += strlen(yytext); return WORD; }

[0-9]+			{ col += strlen(yytext); return INT_NUMBER; }

;			{ ++col;                 return COMMAND_SEPERATOR; }

[\t ]+			{ col += strlen(yytext); }

\n			{ col = 0; ++line; }

.			{ return *yytext; }

%%

void init_lexer(void)
{
  line = 0;
  col  = 0;
}

void cleanup_lexer(void)
{
}
