/* 
   Copyright (C) 1999 Kyle R. Burton, All Rights Reserved
   mortis@voicenet.com
   http://www.bgw.org
   http://www.voicenet.com/~mortis

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <gtk/gtk.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include <gperiodic.h>

#define cvs_version   "$Header: /home/periodic/cvsroot/gperiodic/src/gperiodic.cc,v 1.16 1999/06/30 20:46:01 periodic Exp $";
#define cvs_revision  "$Revision: 1.16 $";
#define cvs_date      "$Date: 1999/06/30 20:46:01 $";
#define cvs_author    "$Author: periodic $";

char *optstr            = "hl:";  // cmdline option string...
table_entry *table_en   = NULL;   // array of table_elements - english
table_entry *table_fr   = NULL;   // - french
table_entry *table_pt   = NULL;   // - portuguese
table_entry *table_es   = NULL;   // - spanish
table_entry *table_de   = NULL;   // - german 
table_entry *table      = table_en;
char ** strings         = strings_en;
int table_size          = 255;    // max size of that table

char *bin = "<no name>";       // get name from argv...


/* 
 * this is where it all starts...
 *
 */
int main( int argc, char** argv )
{
  // init the language tables...
  init_table_en();
  init_table_fr();
  init_table_pt();
  init_table_es();
  init_table_de();
  init_strings();
  set_language("en");

  strings = strings_en;

  gtk_init(&argc,&argv);

  bin = *argv;

  // parse the command line with getopt(3)
  char ch;
  while( -1 != (ch=getopt(argc,argv,optstr)) ) {
    switch(ch) {
      case 'l':
				if( !set_language(optarg) ) {
          g_message("Error, language string: \"%s\" not recognized", optarg);
					set_language("en");
        }
        break;
      case 'h':  show_usage();  exit(0);  break;
      default:   break;
    }
  }

  // create the main window
  GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window),"GPeriodic");
  gtk_container_border_width(GTK_CONTAINER(window),0);

  // connect the close event...
  gtk_signal_connect( GTK_OBJECT(window), "delete-event",
    GTK_SIGNAL_FUNC(main_window_exit), &window );

  // use a vbox for the menubar and the table of elements...
  GtkWidget *vbox = gtk_vbox_new(FALSE,0);
  gtk_container_border_width(GTK_CONTAINER(vbox),2);
  gtk_container_add( GTK_CONTAINER(window), vbox );
  gtk_widget_show(vbox);

  // create the menu using a menufactory...
  GtkItemFactoryEntry menu[4];
  int menu_num_items = sizeof(menu) / sizeof(menu[0]);

  menu[0].path                = strings[STR_MENU_PATH_FILE];
  menu[0].accelerator         = NULL;
  menu[0].callback            = 0;
  menu[0].callback_action     = 0;
  menu[0].item_type           = "<Branch>";

  menu[1].path                = strings[STR_MENU_PATH_FILE_QUIT];
  menu[1].accelerator         = NULL;
  menu[1].callback            = (GtkItemFactoryCallback)menu_file_exit;
  menu[1].callback_action     = 0;
  menu[1].item_type           = "<Item>";

  menu[2].path                = strings[STR_MENU_PATH_HELP];
  menu[2].accelerator         = NULL;
  menu[2].callback            = 0;
  menu[2].callback_action     = 0;
  menu[2].item_type           = "<Branch>";

  menu[3].path                = strings[STR_MENU_PATH_HELP_ABOUT];
  menu[3].accelerator         = NULL;
  menu[3].callback            = (GtkItemFactoryCallback)menu_help_about;
  menu[3].callback_action     = 0;
  menu[3].item_type           = "<Item>";

  // accelerator group for the menu items/acitons
  GtkAccelGroup *accel_group = gtk_accel_group_new();
  GtkItemFactory *item_factory = gtk_item_factory_new( 
    GTK_TYPE_MENU_BAR, "<blah>",  accel_group 
  );
  gtk_item_factory_create_items( item_factory, menu_num_items, menu, NULL );
  gtk_accel_group_attach(accel_group, GTK_OBJECT(window));
  gtk_box_pack_start( 
    GTK_BOX(vbox),
    gtk_item_factory_get_widget(item_factory, "<blah>"), 
    FALSE, FALSE, 0
  );

  // create the table widget to hold the periodic table
  GtkWidget *periodic_table = gtk_table_new(1,1,TRUE);
  gtk_box_pack_end( GTK_BOX(vbox), periodic_table, FALSE, FALSE, 0 );
  gtk_widget_show(periodic_table);

  GdkColor tooltip_color_bg, tooltip_color_fg;

  // now for each element in the table of elements, create a display
  // item for it, and add it to the table...
  for( int i = 0; i < table_size; ++i ) {
    if( !table[i].symbol ) { // stop if no data...
      _DBG(g_message("%s(%d) %s : %d",__FILE__,__LINE__,
             strings[STR_NO_SYMBOL_FOR_INDEX], i));
      break;
    }

    // create the button
    table[i].button = gtk_button_new_with_label(table[i].symbol);
    if( !table[i].button ) {
      g_warning("%s(%d) %s", __FILE__, __LINE__,
        strings[STR_ERROR_BUTTON_WAS_NULL] );
      break;
    }

    // connect the destroy method to it
    gtk_signal_connect( GTK_OBJECT(table[i].button), "clicked",
      GTK_SIGNAL_FUNC(display_element_dialog), &table[i] );

    // set up a string for the tooltips
    char buff[1024];
    sprintf( buff, strings[STR_TOOLTIPS_FORMAT_STRING],
      table[i].name,
      table[i].number,
      table[i].weight);

    // create a new tooltips object...
    table[i].tooltip = gtk_tooltips_new();
    gtk_tooltips_set_delay(table[i].tooltip,100);
    gtk_tooltips_set_tip(table[i].tooltip,table[i].button,buff,NULL);
    gtk_tooltips_set_colors( table[i].tooltip, &tooltip_color_bg, &tooltip_color_fg );

    // attach the button to the table
    gtk_table_attach(
      GTK_TABLE(periodic_table),
      table[i].button,
      table[i].x - 1,
      table[i].x,
      table[i].y - 1,
      table[i].y,
      GTK_FILL,   // xopts
      GTK_FILL,   // yopts
      2,          // xpad
      2           // ypad
    );

    // display it
    gtk_widget_show(table[i].button);
  }

  // show the main winodw
  gtk_widget_show(window);

  // show all the widgets (table/menubar/buttons/etc...) in case
  // some haven't gotten shown already
  gtk_widget_show_all(window);

  // give up controll till they exit the application
  gtk_main();

  // reap the tables..
  delete [] table_en;  table_en = 0;
  delete [] table_fr;  table_fr = 0;
  delete [] table_pt;  table_pt = 0;
  delete [] table_es;  table_es = 0;
  delete [] table_de;  table_de = 0;

  // exit from the application...
  return 0;
}


/*
 * exit hanlder for the main window -- exits the application
 *
 */
void main_window_exit( GtkWidget *w, gpointer d ) 
{
  gtk_main_quit();
}

void display_element_dialog( GtkWidget *w, gpointer d )
{
  table_entry *p = (table_entry*)d;

  _DBG( g_message("%s(%d) display_table_element() w=0x%08x d=0x%08x",
    __FILE__, __LINE__, w, d ) );

  // display this in a dialog box...
  GtkWidget *dialog = gtk_dialog_new();
  gtk_signal_connect(GTK_OBJECT(dialog),"destroy",
    GTK_SIGNAL_FUNC(dialog_destroy), dialog );
   
  char buff[256];
  sprintf(buff,"%.*s",(int)sizeof(buff)-1,p->name);
  gtk_window_set_title( GTK_WINDOW(dialog), buff  );
  gtk_container_set_border_width( GTK_CONTAINER(dialog), 5 );

  GtkWidget *lbl_symbol  = gtk_label_new(strings[STR_SYMBOL]),
            *lbl_name    = gtk_label_new(strings[STR_NAME]),
            *lbl_number  = gtk_label_new(strings[STR_NUMBER]),
            *lbl_weight  = gtk_label_new(strings[STR_WEIGHT]),
            *lbl_melting = gtk_label_new(strings[STR_MELTING_POINT]),
            *lbl_boiling = gtk_label_new(strings[STR_BOILING_POINT]),
            *lbl_pauling = gtk_label_new(strings[STR_PAULING_NEGATIVITY_NUMBER]);

  gtk_label_set_justify( GTK_LABEL(lbl_name), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_symbol), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_number), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_weight), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_melting), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_boiling), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_pauling), GTK_JUSTIFY_LEFT );

  GtkWidget *lbl_symbol_value  = gtk_label_new(p->symbol),
            *lbl_name_value    = gtk_label_new(p->name),
            *lbl_number_value  = gtk_label_new(p->number),
            *lbl_weight_value  = gtk_label_new(p->weight),
            *lbl_melting_value = gtk_label_new(p->melting),
            *lbl_boiling_value = gtk_label_new(p->boiling),
            *lbl_pauling_value = gtk_label_new(p->pauling);

  gtk_label_set_justify( GTK_LABEL(lbl_name_value), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_symbol_value), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_number_value), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_weight_value), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_melting_value), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_boiling_value), GTK_JUSTIFY_LEFT );
  gtk_label_set_justify( GTK_LABEL(lbl_pauling_value), GTK_JUSTIFY_LEFT );


  GtkWidget *vbox = gtk_vbox_new(FALSE,0);

  gtk_box_pack_start( GTK_BOX( GTK_DIALOG(dialog)->action_area),
    vbox, TRUE, TRUE, 0 );
  gtk_widget_show(vbox);

  GtkWidget *tbl = gtk_table_new(5,2,TRUE);
  gtk_box_pack_start( GTK_BOX(vbox), tbl, FALSE, FALSE, 0 );
  gtk_widget_show(tbl);

  // add the labels to the dialog box verticaly...
  int x1 = 0, x2 = 1, y1 = 0, y2 = 1;

  // name
  gtk_table_attach(GTK_TABLE(tbl), lbl_name, x1, x2, y1, y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tbl), lbl_name_value, x1+1, x2+1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(lbl_name);
  gtk_widget_show(lbl_name_value);

  // symbol
  gtk_table_attach(GTK_TABLE(tbl), lbl_symbol, x1, x2, ++y1, ++y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tbl), lbl_symbol_value, x1+1, x2+1, y1, y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(lbl_symbol);
  gtk_widget_show(lbl_symbol_value);

  // number
  gtk_table_attach(GTK_TABLE(tbl), lbl_number, x1, x2, ++y1, ++y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tbl), lbl_number_value, x1+1, x2+1, y1, y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(lbl_number);
  gtk_widget_show(lbl_number_value);

  // weight
  gtk_table_attach(GTK_TABLE(tbl), lbl_weight, x1, x2, ++y1, ++y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tbl), lbl_weight_value, x1+1, x2+1, y1, y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(lbl_weight);
  gtk_widget_show(lbl_weight_value);

  // melting
  gtk_table_attach(GTK_TABLE(tbl), lbl_melting, x1, x2, ++y1, ++y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tbl), lbl_melting_value, x1+1, x2+1, y1, y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(lbl_melting);
  gtk_widget_show(lbl_melting_value);

  // boiling
  gtk_table_attach(GTK_TABLE(tbl), lbl_boiling, x1, x2, ++y1, ++y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tbl), lbl_boiling_value, x1+1, x2+1, y1, y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(lbl_boiling);
  gtk_widget_show(lbl_boiling_value);

  // pauling
  gtk_table_attach(GTK_TABLE(tbl), lbl_pauling, x1, x2, ++y1, ++y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_table_attach(GTK_TABLE(tbl), lbl_pauling_value, x1+1, x2+1, y1, y2, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show(lbl_pauling);
  gtk_widget_show(lbl_pauling_value);

  GtkWidget *ok_button = gtk_button_new_with_label(strings[STR_OK]);
  gtk_signal_connect( GTK_OBJECT(ok_button), "clicked",
    GTK_SIGNAL_FUNC(dialog_close), dialog );

  GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);


  GtkWidget *hbox_space = gtk_hbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(hbox_space),5);
  gtk_box_pack_start( GTK_BOX(vbox), hbox_space, TRUE, TRUE, 0 );
  gtk_widget_show(hbox_space);

  GtkWidget *hbox_ok = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start( GTK_BOX(hbox_ok), ok_button, TRUE, TRUE, 0 );
  gtk_box_pack_end( GTK_BOX(vbox), hbox_ok, TRUE, TRUE, 0 );
  gtk_widget_show(hbox_ok);

  gtk_widget_grab_default(ok_button);

  gtk_widget_show(ok_button);
  gtk_grab_add(dialog);
  gtk_widget_show(dialog);
}

void dialog_destroy( GtkWidget *w, gpointer d )
{
  gtk_grab_remove(GTK_WIDGET(w));
}

void dialog_close( GtkWidget *w, gpointer d )
{
  gtk_widget_destroy(GTK_WIDGET(d));
}



void menu_file_exit( gpointer callback_data, guint callback_action, GtkWidget *w )
{
  main_window_exit(w,NULL);
}

void menu_help_about( gpointer callback_data, guint callback_action, GtkWidget *widget )
{
  GtkWidget *ok_button    = NULL;
  GtkWidget *about_dialog = NULL;
  GtkWidget *label        = NULL;
  gchar buff[2048];

  about_dialog = gtk_dialog_new();

  gtk_signal_connect( GTK_OBJECT(about_dialog), "destroy", 
    GTK_SIGNAL_FUNC(dialog_destroy),
    about_dialog );

  gtk_window_set_title( GTK_WINDOW(about_dialog), "GPeriodic - About" );
  gtk_container_set_border_width( GTK_CONTAINER(about_dialog), 5 );

  sprintf((char*)buff,
    "GPeriodic\n"
    "Brought to you by : mortis@voicenet.com\n"
    "%s : khazuada@univ-littoral.fr\n"
    "%s : mrivera@cable.net.co\n"
    "%s : chris@koeln.ccc.de\n"
    "%s : lalo@linuxcenter.com.br\n"
    "See the Changes file for other credits.", 
		strings[STR_FRENCH_ADAPTATION], strings[STR_SPANISH_ADAPTATION],
		strings[STR_GERMAN_ADAPTATION], strings[STR_PORTUG_ADAPTATION] );

  label = gtk_label_new(buff);

  gtk_misc_set_padding( GTK_MISC(label), 10, 10 );

  gtk_box_pack_start( GTK_BOX(GTK_DIALOG(about_dialog)->vbox),
    label, TRUE, TRUE, 0 );

  gtk_widget_show(label);


  ok_button = gtk_button_new_with_label("Ok");

  gtk_signal_connect( GTK_OBJECT(ok_button), "clicked", 
    GTK_SIGNAL_FUNC(dialog_close), about_dialog );

  GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);

  gtk_box_pack_start( GTK_BOX( GTK_DIALOG(about_dialog)->action_area ),
    ok_button, TRUE, TRUE, 0 );

  gtk_widget_grab_default(ok_button);

  gtk_widget_show(ok_button);

  gtk_widget_show(about_dialog);

}

char* dupstr( const char *s )
{
  char *p = NULL;

  if(s) {
    p = new char[strlen(s)+1];
    strcpy(p,s);
  }

  return p;
}


void show_usage( void )
{
  printf("%s [opts]\n", bin);
  printf("Options are:\n");
  printf("    -h             show this help screen.\n");
  printf("    -l lang        use given language, see below.\n");
  printf("\n");
  printf("Currently Supported Langugae Strings:\n");
  printf("  en         English\n");
  printf("  fr         Franoise (French)\n");
  printf("  es         Espaol   (Spanish)\n");
  printf("  de         Deutsch   (German)\n");
  printf("  pt         Portugus (Portuguese)\n");
  printf("\n");
}


int set_language( const char* lang )
{
	int rv = FALSE;
	if( !strcmp( "en", lang ) ) {
	  strings = strings_en;
		table   = table_en;
		rv      = true;
	}
	else if( !strcmp( "fr", lang ) ) {
	  strings = strings_fr;
		table   = table_fr;
		rv      = true;
	}
	else if( !strcmp( "pt", lang ) ) {
	  strings = strings_pt;
		table   = table_pt;
		rv      = true;
	}
	else if( !strcmp( "es", lang ) ) {
	  strings = strings_es;
		table   = table_es;
		rv      = true;
	}
	else if( !strcmp( "de", lang ) ) {
	  strings = strings_de;
		table   = table_de;
		rv      = true;
	}
	else {
	  printf("%s(%d) Error, unrecognized language string: %s\n",
		  __FILE__, __LINE__, lang );
	}

  return rv;
}
