# gozerbot/monitor.py
#
#

""" monitors .. call callback on bot output. """

__copyright__ = 'this file is in the public domain'

from gozerbot.monitor import Monitor

# gozerbot imports
from ircevent import Ircevent

class Outmonitor(Monitor):

    """ monitor for bot output (bot.send). """

    def handle(self, bot, txt):

        """ fire outmonitor callbacks. """

        ievent = Ircevent().parse(bot, txt)

        if not ievent:
            rlog(10, 'monitor', "can't make ircevent: %s" % txt)
            return

        ievent.nick = bot.nick

        try:
            ievent.userhost = bot.userhosts[bot.nick]
        except KeyError:
            ievent.userhost = "bot@bot"

        Monitor.handle(self, bot, ievent)

# bot.send() monitor
outmonitor = Outmonitor('outmonitor') 

# bot.say() monitor
saymonitor = Monitor('saymonitor')
